/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2012 CASSIDIAN an EADS Company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
package org.ow2.weblab.content.impl;

import java.io.File;
import java.net.URI;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public final class SecureFileContentManager extends FileContentManager {


	public SecureFileContentManager() {
		super();
	}


	/**
	 * This method overrides the unsecure one by verifying if the generated path for
	 * files is a child of the file content manager path
	 */
	@Override
	public File readContent(final URI destUri) throws WebLabCheckedException {
		final File fileToSecure_l = super.readContent(destUri);

		// Check that the file returned by the parent function is inside our path
		final URI contentFolderURI_l = this.getContentFolder().toURI();
		final URI fileToSecureURI_l = fileToSecure_l.toURI();

		final URI resultingURI_l = contentFolderURI_l.relativize(fileToSecureURI_l);
		this.getLogger().debug("URI relativized : " + resultingURI_l);
		if ((resultingURI_l.compareTo(fileToSecureURI_l) == 0) || (resultingURI_l.isAbsolute())) {
			throw new WebLabUncheckedException("File " + fileToSecure_l.getPath() + " is not within Content Manager repository");
		}

		return fileToSecure_l;
	}
}
