/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2012 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.components;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.model.Resource;

public class ResourcesMerger {
	private static ResourcesMerger instance = null;
	private final Log logger = LogFactory.getLog(ResourcesMerger.class);
	
	private ResourcesMerger() {
	}
	
	public static ResourcesMerger getInstance() {
		if(instance == null) {
			instance = new ResourcesMerger();
		}
		return instance;
	}
	
	public Resource merge(final Resource initialResource, final Resource ... resourcesToMerge) {
		if(resourcesToMerge.length == 0 || initialResource == null) {
			throw new IllegalArgumentException("No initial Resource or no Resource to merge");
		}
		if(resourcesToMerge.length == 1) {
			return resourcesToMerge[0];
		}
		
//		XMLMerger merger = new XMLMerger(logger);
		WebLabMerger merger = new WebLabMerger(logger);
		Resource result = merger.merge(initialResource, resourcesToMerge);
		
		return result;
	}
	
	public Resource merge(final Resource initialResource, List<Resource> resourcesToMerge) {
		if(resourcesToMerge.isEmpty() || initialResource == null) {
			throw new IllegalArgumentException("No initial Resource or no Resource to merge");
		}
		if(resourcesToMerge.size() == 1) {
			return resourcesToMerge.get(0);
		}
		
//		XMLMerger merger = new XMLMerger(logger);
		WebLabMerger merger = new WebLabMerger(logger);
		Resource result = merger.merge(initialResource, resourcesToMerge);
		
		return result;
	}
}
