/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2012 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.components;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.model.Resource;

class XMLMerger {
	private final Log logger;
	
	public XMLMerger(Log logger) {
		this.logger = logger;
	}
	
	Resource merge(final Resource initialResource,
			final Resource... resourcesToMerge) {
		List<Document> resourcesAsXML = null;
		Document initialResourceAsXML = null;

		try {
			resourcesAsXML = getXMLDocuments(resourcesToMerge);
			initialResourceAsXML = getXMLDocument(initialResource);
		} catch (IOException e) {
			logger.error("Error while parsing resource in XML", e);
		} catch (JDOMException e) {
			logger.error("Error while parsing resource in XML", e);
		} catch (WebLabCheckedException e) {
			logger.error("Error while parsing resource in XML", e);
		}

		Resource result = null;
		if (resourcesAsXML != null && resourcesAsXML.size() > 1
				&& initialResourceAsXML != null) {
			try {
				result = doMerge(initialResourceAsXML, resourcesAsXML);
			} catch (JDOMException e) {
				logger.error("Error while merging resource", e);
			}
		} else {
			logger.error("resourcesAsXML is null or empty");
		}

		return result;
	}

	private List<Document> getXMLDocuments(Resource[] resourcesToMerge)
			throws IOException, JDOMException, WebLabCheckedException {
		final List<Document> result = new LinkedList<Document>();

		for (final Resource resource : resourcesToMerge) {
			Document dom = getXMLDocument(resource);
			result.add(dom);
		}
		return result;
	}

	private Document getXMLDocument(final Resource resource)
			throws IOException, JDOMException, WebLabCheckedException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		final WebLabMarshaller wm = new WebLabMarshaller();

		SAXBuilder saxBuilder = new SAXBuilder();

		wm.marshalResource(resource, out);
		Document dom = saxBuilder.build(new ByteArrayInputStream(out
				.toByteArray()));
		return dom;
	}

	private Resource doMerge(Document initialResourceAsXML,
			List<Document> resourcesAsXML) throws JDOMException {
		// TODO Auto-generated method stub

		// Map<Document, List<Node>> newNodes = new HashMap<Document,
		// List<Node>>();
		// for (Document document : resourcesAsXML) {
		// newNodes.put(document, new LinkedList<Node>());
		// }
		//
		// Map<Document, List<Attr>> newAttrs = new HashMap<Document,
		// List<Attr>>();
		// for (Document document : resourcesAsXML) {
		// newAttrs.put(document, new LinkedList<Attr>());
		// }
		//

		List<String> doneURIs = new LinkedList<String>();
		for (Object o : initialResourceAsXML.getRootElement().getChildren()) {
			if (o instanceof Element) {
				Element element = (Element) o;
				if (element.getAttribute("uri") != null) {
					List<Element> nodeList = new LinkedList<Element>();
					for (Document document : resourcesAsXML) {
						Object currentObject = XPath.selectSingleNode(
								document.getRootElement(), "/"
										+ document.getRootElement().getName()
										+ "/" + element.getName() + "[@uri]");
						nodeList.add((Element) currentObject);
						logger.info(isElementsIdentical(element,
								nodeList, "/"
										+ initialResourceAsXML.getRootElement()
												.getName()));
						// logger.info(currentObject);
					}
					if (nodeList.isEmpty()) {
						mergeNode(element, nodeList, "/"
								+ initialResourceAsXML.getRootElement()
										.getName() + "/" + element.getName());
					}
					doneURIs.add(element.getAttribute("uri").getValue());
				}
			}
			// Node currentNode = initialResourceAsXML.getChildNodes().item(i);
			// for (Document document : resourcesAsXML) {
			//
			// }
		}

		// initialResourceAsXML.

		return null;
	}

	private boolean isElementsIdentical(Element initialElement,
			List<Element> elementsToMerge, String currentXPath)
			throws JDOMException {
		String xpath = currentXPath + "//*";
		Object initialXpathElements = XPath.selectNodes(initialElement, xpath);
		logger.info(initialXpathElements);

		for (Element element : elementsToMerge) {
			Object currentXpathElements = XPath.selectNodes(element, xpath);
			logger.info(currentXpathElements);
			if (!currentXpathElements.equals(initialXpathElements)) {
				return false;
			}
		}

		return true;
	}

	private void mergeNode(Element initialElement,
			List<Element> elementsToMerge, String currentXPath)
			throws JDOMException {
		List<String> doneURIs = new LinkedList<String>();
		for (Object o : initialElement.getChildren()) {
			if (o instanceof Element) {
				Element element = (Element) o;
				// logger.info(element);
				if (element.getAttribute("uri") == null) {
					logger.error("URI attribute not found");
				} else {
					List<Element> nodeList = new LinkedList<Element>();
					for (Element currentElement : elementsToMerge) {
						Object currentObject = XPath.selectSingleNode(
								currentElement, currentXPath + "/"
										+ currentElement.getName() + "/"
										+ element.getName() + "[@uri]");
						nodeList.add((Element) currentObject);
						logger.info(currentObject);
					}
					if (nodeList.isEmpty()) {
						mergeNode(element, nodeList, currentXPath + "/"
								+ element.getName());
					}
					doneURIs.add(element.getAttribute("uri").getValue());
				}
			}
			// Node currentNode = initialResourceAsXML.getChildNodes().item(i);
			// for (Document document : resourcesAsXML) {
			//
			// }
		}
	}
}
