/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.components;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.components.WebLabMerger;
import org.ow2.weblab.core.model.Resource;

public class ResourcesMerger {
    private static ResourcesMerger instance = null;
    private final Log logger = LogFactory.getLog(ResourcesMerger.class);

    private ResourcesMerger() {
    }

    public static ResourcesMerger getInstance() {
        if (instance == null) {
            instance = new ResourcesMerger();
        }
        return instance;
    }

    public Resource merge(Resource initialResource, Resource ... resourcesToMerge) {
        if (resourcesToMerge.length == 0 || initialResource == null) {
            throw new IllegalArgumentException("No initial Resource or no Resource to merge");
        }
        if (resourcesToMerge.length == 1) {
            return resourcesToMerge[0];
        }
        WebLabMerger merger = new WebLabMerger(this.logger);
        Resource result = merger.merge(initialResource, resourcesToMerge);
        return result;
    }

    public Resource merge(Resource initialResource, List<Resource> resourcesToMerge) {
        if (resourcesToMerge.isEmpty() || initialResource == null) {
            throw new IllegalArgumentException("No initial Resource or no Resource to merge");
        }
        if (resourcesToMerge.size() == 1) {
            return resourcesToMerge.get(0);
        }
        WebLabMerger merger = new WebLabMerger(this.logger);
        Resource result = merger.merge(initialResource, resourcesToMerge);
        return result;
    }
}

