/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.components;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.IPredicateValuePairs;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.Audio;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Image;
import org.ow2.weblab.core.model.LowLevelDescriptor;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.model.Video;

class WebLabMerger {
    private final Log logger;

    public WebLabMerger(Log logger) {
        this.logger = logger;
    }

    Resource merge(Resource initialResource, Resource[] resourcesToMerge) {
        List<String> initialURIs = this.listURIs(initialResource);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        LinkedList<String> newURIs = new LinkedList<String>();
        for (Resource resource : resourcesToMerge) {
            List<String> URIs = this.listURIs(resource);
            LinkedList<String> toChangedURIs = new LinkedList<String>();
            for (String string : URIs) {
                if (initialURIs.contains(string)) continue;
                if (newURIs.contains(string)) {
                    toChangedURIs.add(string);
                    continue;
                }
                newURIs.add(string);
            }
            if (toChangedURIs.isEmpty()) {
                resources.add(resource);
                continue;
            }
            resources.add(this.changeURIs(resource, toChangedURIs));
        }
        this.mergeResource(initialResource, resources);
        return initialResource;
    }

    Resource merge(Resource initialResource, List<Resource> resourcesToMerge) {
        List<String> initialURIs = this.listURIs(initialResource);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        LinkedList<String> newURIs = new LinkedList<String>();
        for (Resource resource : resourcesToMerge) {
            List<String> URIs = this.listURIs(resource);
            LinkedList<String> toChangedURIs = new LinkedList<String>();
            for (String string : URIs) {
                if (initialURIs.contains(string)) continue;
                if (newURIs.contains(string)) {
                    toChangedURIs.add(string);
                    continue;
                }
                newURIs.add(string);
            }
            if (toChangedURIs.isEmpty()) {
                resources.add(resource);
                continue;
            }
            resources.add(this.changeURIs(resource, toChangedURIs));
        }
        this.mergeResource(initialResource, resources);
        return initialResource;
    }

    private Resource changeURIs(Resource resource, List<String> toChangedURIs) {
        try {
            StringWriter sw = new StringWriter();
            WebLabMarshaller wm = new WebLabMarshaller();
            wm.marshalResource(resource, (Writer)sw);
            String resourceAsString = sw.toString();
            for (String string : toChangedURIs) {
                String oldUri = "\"" + string + "\"";
                String newUri = "\"weblab://" + this.getNewURI() + "\"";
                resourceAsString = resourceAsString.replace(oldUri, newUri);
            }
            Resource result = wm.unmarshal((Reader)new StringReader(resourceAsString), Document.class);
            return result;
        }
        catch (WebLabCheckedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getNewURI() {
        return UUID.randomUUID().toString();
    }

    private List<String> listURIs(Resource resource) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WebLabMarshaller wm = new WebLabMarshaller();
            SAXBuilder saxBuilder = new SAXBuilder();
            wm.marshalResource(resource, (OutputStream)out);
            org.jdom.Document dom = saxBuilder.build((InputStream)new ByteArrayInputStream(out.toByteArray()));
            return this.listURIs(dom);
        }
        catch (WebLabCheckedException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<String> listURIs(org.jdom.Document dom) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            List list = XPath.selectNodes((Object)dom, (String)"//*[@uri]");
            for (Object object : list) {
                if (!(object instanceof Element)) continue;
                Element e = (Element)object;
                result.add(e.getAttributeValue("uri"));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void mergeResource(Resource initialResource, List<Resource> resourcesToMerge) {
        int i;
        boolean notFound;
        LinkedList<String> doneURIs = new LinkedList<String>();
        for (Annotation initialAnnotation : initialResource.getAnnotation()) {
            LinkedList<Resource> annotationsToMerge = new LinkedList<Resource>();
            for (Resource resource : resourcesToMerge) {
                notFound = true;
                for (i = 0; i < resource.getAnnotation().size() && notFound; ++i) {
                    if (!((Annotation)resource.getAnnotation().get(i)).getUri().equals(initialAnnotation.getUri())) continue;
                    notFound = false;
                    annotationsToMerge.add((Resource)resource.getAnnotation().get(i));
                }
                if (!notFound) continue;
                this.logger.warn((Object)"Annotation remove not handle");
            }
            this.mergeResource((Resource)initialAnnotation, annotationsToMerge);
            doneURIs.add(initialAnnotation.getUri());
        }
        for (Resource resource : resourcesToMerge) {
            for (Annotation annotation : resource.getAnnotation()) {
                if (doneURIs.contains(annotation.getUri())) continue;
                this.logger.info((Object)"Add Annotation to Resource");
                initialResource.getAnnotation().add(annotation);
            }
        }
        for (LowLevelDescriptor initialLowLevelDescriptor : initialResource.getDescriptor()) {
            LinkedList<Resource> lowLevelDescriptorsToMerge = new LinkedList<Resource>();
            for (Resource resource : resourcesToMerge) {
                notFound = true;
                for (i = 0; i < resource.getDescriptor().size() && notFound; ++i) {
                    if (!((LowLevelDescriptor)resource.getDescriptor().get(i)).getUri().equals(initialLowLevelDescriptor.getUri())) continue;
                    notFound = false;
                    lowLevelDescriptorsToMerge.add((Resource)resource.getDescriptor().get(i));
                }
                if (!notFound) continue;
                this.logger.warn((Object)"LowLevelDescriptor remove not handle");
            }
            this.mergeResource((Resource)initialLowLevelDescriptor, lowLevelDescriptorsToMerge);
            doneURIs.add(initialLowLevelDescriptor.getUri());
        }
        for (Resource resource : resourcesToMerge) {
            for (LowLevelDescriptor lowLevelDescriptor : resource.getDescriptor()) {
                if (doneURIs.contains(lowLevelDescriptor.getUri())) continue;
                this.logger.info((Object)"Add LowLevelDescriptor to Resource");
                initialResource.getDescriptor().add(lowLevelDescriptor);
            }
        }
        if (initialResource instanceof MediaUnit) {
            MediaUnit initialMediaUnit = (MediaUnit)initialResource;
            LinkedList<MediaUnit> mediaUnitsToMerge = new LinkedList<MediaUnit>();
            for (Resource resource : resourcesToMerge) {
                if (resource instanceof MediaUnit) {
                    MediaUnit mediaUnit = (MediaUnit)resource;
                    mediaUnitsToMerge.add(mediaUnit);
                    continue;
                }
                this.logger.error((Object)("Resource is " + resource.getClass() + " and a " + initialResource.getClass() + "was needed"));
            }
            this.mergeMediaUnit(initialMediaUnit, mediaUnitsToMerge);
        } else if (initialResource instanceof ComposedResource) {
            ComposedResource initialComposedResource = (ComposedResource)initialResource;
            LinkedList<ComposedResource> composedResourcesToMerge = new LinkedList<ComposedResource>();
            for (Resource resource : resourcesToMerge) {
                if (resource instanceof ComposedResource) {
                    ComposedResource composedResource = (ComposedResource)resource;
                    composedResourcesToMerge.add(composedResource);
                    continue;
                }
                this.logger.error((Object)("Resource is " + resource.getClass() + " and a " + initialResource.getClass() + "was needed"));
            }
            this.mergeComposedResource(initialComposedResource, composedResourcesToMerge);
        } else if (initialResource instanceof LowLevelDescriptor) {
            LowLevelDescriptor initialLowLevelDescriptor = (LowLevelDescriptor)initialResource;
            LinkedList<LowLevelDescriptor> lowLevelDescriptorsToMerge = new LinkedList<LowLevelDescriptor>();
            for (Resource resource : resourcesToMerge) {
                if (resource instanceof LowLevelDescriptor) {
                    LowLevelDescriptor annotation = (LowLevelDescriptor)resource;
                    lowLevelDescriptorsToMerge.add(annotation);
                    continue;
                }
                this.logger.error((Object)("Resource is " + resource.getClass() + " and a " + initialResource.getClass() + "was needed"));
            }
            this.mergeLowLevelDescriptor(initialLowLevelDescriptor, lowLevelDescriptorsToMerge);
        } else if (initialResource instanceof PieceOfKnowledge) {
            PieceOfKnowledge initialPOK = (PieceOfKnowledge)initialResource;
            LinkedList<PieceOfKnowledge> poksToMerge = new LinkedList<PieceOfKnowledge>();
            for (Resource resource : resourcesToMerge) {
                if (resource instanceof PieceOfKnowledge) {
                    PieceOfKnowledge pok = (PieceOfKnowledge)resource;
                    poksToMerge.add(pok);
                    continue;
                }
                this.logger.error((Object)("Resource is " + resource.getClass() + " and a " + initialResource.getClass() + "was needed"));
            }
            this.mergePieceOfKnowledge(initialPOK, poksToMerge);
        } else if (initialResource instanceof Query) {
            Query initialQuery = (Query)initialResource;
            LinkedList<Query> querysToMerge = new LinkedList<Query>();
            for (Resource resource : resourcesToMerge) {
                if (resource instanceof Query) {
                    Query query = (Query)resource;
                    querysToMerge.add(query);
                    continue;
                }
                this.logger.error((Object)("Resource is " + resource.getClass() + " and a " + initialResource.getClass() + "was needed"));
            }
            this.mergeQuery(initialQuery, querysToMerge);
        } else if (initialResource instanceof ResultSet) {
            ResultSet initialResultSet = (ResultSet)initialResource;
            LinkedList<ResultSet> resultSetsToMerge = new LinkedList<ResultSet>();
            for (Resource resource : resourcesToMerge) {
                if (resource instanceof ResultSet) {
                    ResultSet resultSet = (ResultSet)resource;
                    resultSetsToMerge.add(resultSet);
                    continue;
                }
                this.logger.error((Object)("Resource is " + resource.getClass() + " and a " + initialResource.getClass() + "was needed"));
            }
            this.mergeResultSet(initialResultSet, resultSetsToMerge);
        } else {
            this.logger.warn((Object)("Resource type : " + initialResource.getClass() + "not completely handle"));
        }
    }

    private void mergeResultSet(ResultSet initialResultSet, List<ResultSet> resultSetsToMerge) {
        this.logger.warn((Object)"ResultSet not handle yet (has it to be?...)");
    }

    private void mergeQuery(Query initialQuery, List<Query> querysToMerge) {
        this.logger.warn((Object)"Query not handle yet (has it to be?...)");
    }

    private void mergePieceOfKnowledge(PieceOfKnowledge initialPOK, List<PieceOfKnowledge> poksToMerge) {
        this.mergeData(initialPOK, poksToMerge);
        if (initialPOK instanceof Annotation) {
            Annotation initialAnnotation = (Annotation)initialPOK;
            LinkedList<Annotation> annotationsToMerge = new LinkedList<Annotation>();
            for (PieceOfKnowledge pok : poksToMerge) {
                if (pok instanceof Annotation) {
                    Annotation annotation = (Annotation)pok;
                    annotationsToMerge.add(annotation);
                    continue;
                }
                this.logger.error((Object)("PieceOfKnowledge is " + pok.getClass() + " and a " + initialPOK.getClass() + "was needed"));
            }
            this.mergeAnnotation(initialAnnotation, annotationsToMerge);
        }
    }

    private void mergeAnnotation(Annotation initialAnnotation, List<Annotation> annotationsToMerge) {
        this.logger.warn((Object)"Annotation merge not handle for now, nothing to do here");
    }

    private void mergeComposedResource(ComposedResource initialComposedResource, List<ComposedResource> composedResourcesToMerge) {
        LinkedList<String> doneURIs = new LinkedList<String>();
        for (Resource initialResource : initialComposedResource.getResource()) {
            LinkedList<Resource> resourcesToMerge = new LinkedList<Resource>();
            for (ComposedResource composedResource : composedResourcesToMerge) {
                boolean notFound = true;
                for (int i = 0; i < composedResource.getResource().size() && notFound; ++i) {
                    if (!((Resource)composedResource.getResource().get(i)).getUri().equals(initialResource.getUri())) continue;
                    notFound = false;
                    resourcesToMerge.add((Resource)composedResource.getResource().get(i));
                }
                if (!notFound) continue;
                this.logger.warn((Object)"Resource remove not handle");
            }
            this.mergeResource(initialResource, resourcesToMerge);
            doneURIs.add(initialResource.getUri());
        }
        for (ComposedResource composedResource : composedResourcesToMerge) {
            for (Resource resource : composedResource.getResource()) {
                if (doneURIs.contains(resource.getUri())) continue;
                this.logger.info((Object)"Add Resource to ComposedResource");
                initialComposedResource.getResource().add(resource);
            }
        }
    }

    private void mergeMediaUnit(MediaUnit initialMediaUnit, List<MediaUnit> mediaUnitsToMerge) {
        LinkedList<String> doneURIs = new LinkedList<String>();
        for (Segment initialSegment : initialMediaUnit.getSegment()) {
            LinkedList<Segment> segmentsToMerge = new LinkedList<Segment>();
            for (MediaUnit mediaUnit : mediaUnitsToMerge) {
                boolean notFound = true;
                for (int i = 0; i < mediaUnit.getSegment().size() && notFound; ++i) {
                    if (!((Segment)mediaUnit.getSegment().get(i)).getUri().equals(initialSegment.getUri())) continue;
                    notFound = false;
                    segmentsToMerge.add((Segment)mediaUnit.getSegment().get(i));
                }
                if (!notFound) continue;
                this.logger.warn((Object)"Segment remove not handle");
            }
            this.mergeSegment(initialSegment, segmentsToMerge);
            doneURIs.add(initialSegment.getUri());
        }
        for (MediaUnit mediaUnit : mediaUnitsToMerge) {
            for (Segment segment : mediaUnit.getSegment()) {
                if (doneURIs.contains(segment.getUri())) continue;
                this.logger.info((Object)"Add Segment to MediaUnit");
                initialMediaUnit.getSegment().add(segment);
            }
        }
        if (initialMediaUnit instanceof Document) {
            Document initialDocument = (Document)initialMediaUnit;
            LinkedList<Document> documentsToMerge = new LinkedList<Document>();
            for (MediaUnit mediaUnit : mediaUnitsToMerge) {
                if (mediaUnit instanceof Document) {
                    documentsToMerge.add((Document)mediaUnit);
                    continue;
                }
                this.logger.error((Object)("MediaUnit is " + mediaUnit.getClass() + " and a " + initialMediaUnit.getClass() + "was needed"));
            }
            if (!documentsToMerge.isEmpty()) {
                this.mergeDocument(initialDocument, documentsToMerge);
            }
        } else if (initialMediaUnit instanceof Audio) {
            Audio initialAudio = (Audio)initialMediaUnit;
            LinkedList<Audio> audiosToMerge = new LinkedList<Audio>();
            for (MediaUnit mediaUnit : mediaUnitsToMerge) {
                if (mediaUnit instanceof Audio) {
                    audiosToMerge.add((Audio)mediaUnit);
                    continue;
                }
                this.logger.error((Object)("MediaUnit is " + mediaUnit.getClass() + " and a " + initialMediaUnit.getClass() + "was needed"));
            }
            if (!audiosToMerge.isEmpty()) {
                this.mergeAudio(initialAudio, audiosToMerge);
            }
        } else if (initialMediaUnit instanceof Image) {
            Image initialImage = (Image)initialMediaUnit;
            LinkedList<Image> imagesToMerge = new LinkedList<Image>();
            for (MediaUnit mediaUnit : mediaUnitsToMerge) {
                if (mediaUnit instanceof Image) {
                    imagesToMerge.add((Image)mediaUnit);
                    continue;
                }
                this.logger.error((Object)("MediaUnit is " + mediaUnit.getClass() + " and a " + initialMediaUnit.getClass() + "was needed"));
            }
            if (!imagesToMerge.isEmpty()) {
                this.mergeImage(initialImage, imagesToMerge);
            }
        } else if (initialMediaUnit instanceof Text) {
            Text initialText = (Text)initialMediaUnit;
            LinkedList<Text> textsToMerge = new LinkedList<Text>();
            for (MediaUnit mediaUnit : mediaUnitsToMerge) {
                if (mediaUnit instanceof Text) {
                    textsToMerge.add((Text)mediaUnit);
                    continue;
                }
                this.logger.error((Object)("MediaUnit is " + mediaUnit.getClass() + " and a " + initialMediaUnit.getClass() + "was needed"));
            }
            if (!textsToMerge.isEmpty()) {
                this.mergeText(initialText, textsToMerge);
            }
        } else if (initialMediaUnit instanceof Video) {
            Video initialVideo = (Video)initialMediaUnit;
            LinkedList<Video> videosToMerge = new LinkedList<Video>();
            for (MediaUnit mediaUnit : mediaUnitsToMerge) {
                if (mediaUnit instanceof Video) {
                    videosToMerge.add((Video)mediaUnit);
                    continue;
                }
                this.logger.error((Object)("MediaUnit is " + mediaUnit.getClass() + " and a " + initialMediaUnit.getClass() + "was needed"));
            }
            if (!videosToMerge.isEmpty()) {
                this.mergeVideo(initialVideo, videosToMerge);
            }
        } else {
            this.logger.warn((Object)("MediaUnit type : " + initialMediaUnit.getClass() + "not completely handle"));
        }
    }

    private void mergeVideo(Video initialVideo, List<Video> videosToMerge) {
        this.logger.warn((Object)"Video content not handle yet (has it to be?...)");
    }

    private void mergeText(Text initialText, List<Text> textsToMerge) {
        this.logger.warn((Object)"Text content not handle yet (has it to be?...)");
    }

    private void mergeImage(Image initialImage, List<Image> imagesToMerge) {
        this.logger.warn((Object)"Image content not handle yet (has it to be?...)");
    }

    private void mergeAudio(Audio initialAudio, List<Audio> audiosToMerge) {
        this.logger.warn((Object)"Audio content not handle yet (has it to be?...)");
    }

    private void mergeDocument(Document initialDocument, List<Document> documentsToMerge) {
        LinkedList<String> doneURIs = new LinkedList<String>();
        for (MediaUnit initialMediaUnit : initialDocument.getMediaUnit()) {
            LinkedList<Resource> mediaUnitsToMerge = new LinkedList<Resource>();
            for (Document document : documentsToMerge) {
                boolean notFound = true;
                for (int i = 0; i < document.getMediaUnit().size() && notFound; ++i) {
                    if (!((MediaUnit)document.getMediaUnit().get(i)).getUri().equals(initialMediaUnit.getUri())) continue;
                    notFound = false;
                    mediaUnitsToMerge.add((Resource)document.getMediaUnit().get(i));
                }
                if (!notFound) continue;
                this.logger.warn((Object)"MediaUnit remove not handle");
            }
            this.mergeResource((Resource)initialMediaUnit, mediaUnitsToMerge);
            doneURIs.add(initialMediaUnit.getUri());
        }
        for (Document document : documentsToMerge) {
            for (MediaUnit mediaUnit : document.getMediaUnit()) {
                if (doneURIs.contains(mediaUnit.getUri())) continue;
                this.logger.info((Object)"Add MediaUnit to Document");
                initialDocument.getMediaUnit().add(mediaUnit);
            }
        }
    }

    private void mergeLowLevelDescriptor(LowLevelDescriptor initialLowLevelDescriptor, List<LowLevelDescriptor> lowLevelDescriptorsToMerge) {
        this.logger.warn((Object)"LowLevelDescriptor merge not handle for now");
    }

    private void mergeSegment(Segment initialSegment, List<Segment> segmentsToMerge) {
        this.logger.warn((Object)"Segment merge not handle for now");
    }

    private void mergeData(PieceOfKnowledge initialPOK, List<PieceOfKnowledge> poksToMerge) {
        AdvancedSelector initialSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
        initialSelector.limitToFirstLevelAnnotation(true);
        Statements initialData = initialSelector.searchFor((Resource)initialPOK, new String[0]);
        HashMap<String, Map<String, List<String>>> statementToAdd = new HashMap<String, Map<String, List<String>>>();
        for (PieceOfKnowledge pok : poksToMerge) {
            AdvancedSelector selector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
            selector.limitToFirstLevelAnnotation(true);
            Statements data = selector.searchFor((Resource)pok, new String[0]);
            for (String subject : data.keySet()) {
                if (initialData.containsKey((Object)subject)) {
                    IPredicateValuePairs initialPairs = (IPredicateValuePairs)initialData.get((Object)subject);
                    IPredicateValuePairs currentPairs = (IPredicateValuePairs)data.get((Object)subject);
                    for (String predicate : currentPairs.allPredicates()) {
                        List currentList;
                        String currentString;
                        Object currentValues;
                        Object initialValues = initialPairs.getValue(predicate);
                        if (initialValues == null) {
                            this.addStatement(statementToAdd, subject, predicate, currentPairs.getValue(predicate));
                            continue;
                        }
                        if (initialValues instanceof String) {
                            String initialString = (String)initialValues;
                            currentValues = currentPairs.getValue(predicate);
                            if (currentValues instanceof String) {
                                currentString = (String)currentValues;
                                if (currentString.equals(initialString)) continue;
                                this.addStatement(statementToAdd, subject, predicate, currentString);
                                continue;
                            }
                            if (!(currentValues instanceof List)) continue;
                            currentList = (List)currentValues;
                            for (Object object : currentList) {
                                String s = (String)object;
                                if (s.equals(initialString)) continue;
                                this.addStatement(statementToAdd, subject, predicate, s);
                            }
                            continue;
                        }
                        if (!(initialValues instanceof List)) continue;
                        List initialList = (List)initialValues;
                        currentValues = currentPairs.getValue(predicate);
                        if (currentValues instanceof String) {
                            currentString = (String)currentValues;
                            if (initialList.contains(currentString)) continue;
                            this.addStatement(statementToAdd, subject, predicate, currentString);
                            continue;
                        }
                        if (!(currentValues instanceof List)) continue;
                        currentList = (List)currentValues;
                        for (Object object : currentList) {
                            String currentString2 = (String)object;
                            boolean notFound = true;
                            for (int i = 0; i < initialList.size() && notFound; ++i) {
                                String initialString = (String)initialList.get(i);
                                if (!initialString.equals(currentString2)) continue;
                                notFound = false;
                            }
                            if (!notFound) continue;
                            this.addStatement(statementToAdd, subject, predicate, currentString2);
                        }
                    }
                    continue;
                }
                this.logger.error((Object)"Annotation not a the same subject");
            }
        }
        this.writeStatements(statementToAdd, initialData, initialPOK);
    }

    private void addStatement(Map<String, Map<String, List<String>>> statementToAdd, String subject, String predicate, Object value) {
        if (value != null && statementToAdd != null) {
            Map<Object, Object> mapSubject = null;
            if (statementToAdd.containsKey(subject)) {
                mapSubject = statementToAdd.get(subject);
            } else {
                mapSubject = new HashMap();
                statementToAdd.put(subject, mapSubject);
            }
            if (mapSubject != null) {
                List<String> listPred = null;
                if (mapSubject.containsKey(predicate)) {
                    listPred = (List)mapSubject.get(predicate);
                } else {
                    listPred = new LinkedList();
                    mapSubject.put(predicate, listPred);
                }
                if (listPred != null) {
                    if (value instanceof String) {
                        String s = (String)value;
                        if (!listPred.contains(s)) {
                            listPred.add(s);
                        }
                    } else if (value instanceof List) {
                        List list = (List)value;
                        if (!listPred.containsAll(list)) {
                            for (Object object : list) {
                                if (!(object instanceof String) || listPred.contains(object)) continue;
                                listPred.add((String)object);
                            }
                        }
                    } else {
                        this.logger.error((Object)"Value class not known.");
                    }
                }
            }
        }
    }

    private void writeStatements(Map<String, Map<String, List<String>>> statementToAdd, Statements initialData, PieceOfKnowledge initialPOK) {
        for (String subject : statementToAdd.keySet()) {
            Map<String, List<String>> currentStatements = statementToAdd.get(subject);
            if (initialData.containsKey((Object)subject)) {
                for (String predicate : currentStatements.keySet()) {
                    List<String> list = currentStatements.get(predicate);
                    for (String string : list) {
                        try {
                            JenaPoKHelper jph = new JenaPoKHelper(initialPOK);
                            jph.createLitStat(subject, predicate, string);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Failed to write Statement");
                            e.printStackTrace();
                        }
                    }
                }
                continue;
            }
            this.logger.error((Object)"Subject merge not yet implemented");
        }
    }
}

