/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.components;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.model.Resource;

class XMLMerger {
    private final Log logger;

    public XMLMerger(Log logger) {
        this.logger = logger;
    }

    Resource merge(Resource initialResource, Resource ... resourcesToMerge) {
        List<Document> resourcesAsXML = null;
        Document initialResourceAsXML = null;
        try {
            resourcesAsXML = this.getXMLDocuments(resourcesToMerge);
            initialResourceAsXML = this.getXMLDocument(initialResource);
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while parsing resource in XML", (Throwable)e);
        }
        catch (JDOMException e) {
            this.logger.error((Object)"Error while parsing resource in XML", (Throwable)e);
        }
        catch (WebLabCheckedException e) {
            this.logger.error((Object)"Error while parsing resource in XML", (Throwable)e);
        }
        Resource result = null;
        if (resourcesAsXML != null && resourcesAsXML.size() > 1 && initialResourceAsXML != null) {
            try {
                result = this.doMerge(initialResourceAsXML, resourcesAsXML);
            }
            catch (JDOMException e) {
                this.logger.error((Object)"Error while merging resource", (Throwable)e);
            }
        } else {
            this.logger.error((Object)"resourcesAsXML is null or empty");
        }
        return result;
    }

    private List<Document> getXMLDocuments(Resource[] resourcesToMerge) throws IOException, JDOMException, WebLabCheckedException {
        LinkedList<Document> result = new LinkedList<Document>();
        for (Resource resource : resourcesToMerge) {
            Document dom = this.getXMLDocument(resource);
            result.add(dom);
        }
        return result;
    }

    private Document getXMLDocument(Resource resource) throws IOException, JDOMException, WebLabCheckedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WebLabMarshaller wm = new WebLabMarshaller();
        SAXBuilder saxBuilder = new SAXBuilder();
        wm.marshalResource(resource, (OutputStream)out);
        Document dom = saxBuilder.build((InputStream)new ByteArrayInputStream(out.toByteArray()));
        return dom;
    }

    private Resource doMerge(Document initialResourceAsXML, List<Document> resourcesAsXML) throws JDOMException {
        LinkedList<String> doneURIs = new LinkedList<String>();
        for (Object o : initialResourceAsXML.getRootElement().getChildren()) {
            Element element;
            if (!(o instanceof Element) || (element = (Element)o).getAttribute("uri") == null) continue;
            LinkedList<Element> nodeList = new LinkedList<Element>();
            for (Document document : resourcesAsXML) {
                Object currentObject = XPath.selectSingleNode((Object)document.getRootElement(), (String)("/" + document.getRootElement().getName() + "/" + element.getName() + "[@uri]"));
                nodeList.add((Element)currentObject);
                this.logger.info((Object)this.isElementsIdentical(element, nodeList, "/" + initialResourceAsXML.getRootElement().getName()));
            }
            if (nodeList.isEmpty()) {
                this.mergeNode(element, nodeList, "/" + initialResourceAsXML.getRootElement().getName() + "/" + element.getName());
            }
            doneURIs.add(element.getAttribute("uri").getValue());
        }
        return null;
    }

    private boolean isElementsIdentical(Element initialElement, List<Element> elementsToMerge, String currentXPath) throws JDOMException {
        String xpath = currentXPath + "//*";
        List initialXpathElements = XPath.selectNodes((Object)initialElement, (String)xpath);
        this.logger.info((Object)initialXpathElements);
        for (Element element : elementsToMerge) {
            List currentXpathElements = XPath.selectNodes((Object)element, (String)xpath);
            this.logger.info((Object)currentXpathElements);
            if (((Object)currentXpathElements).equals(initialXpathElements)) continue;
            return false;
        }
        return true;
    }

    private void mergeNode(Element initialElement, List<Element> elementsToMerge, String currentXPath) throws JDOMException {
        LinkedList<String> doneURIs = new LinkedList<String>();
        for (Object o : initialElement.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element element = (Element)o;
            if (element.getAttribute("uri") == null) {
                this.logger.error((Object)"URI attribute not found");
                continue;
            }
            LinkedList<Element> nodeList = new LinkedList<Element>();
            for (Element currentElement : elementsToMerge) {
                Object currentObject = XPath.selectSingleNode((Object)currentElement, (String)(currentXPath + "/" + currentElement.getName() + "/" + element.getName() + "[@uri]"));
                nodeList.add((Element)currentObject);
                this.logger.info(currentObject);
            }
            if (nodeList.isEmpty()) {
                this.mergeNode(element, nodeList, currentXPath + "/" + element.getName());
            }
            doneURIs.add(element.getAttribute("uri").getValue());
        }
    }
}

