/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.impl.webdav;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.ow2.weblab.content.api.ContentManager;
import org.ow2.weblab.content.api.ContentReader;
import org.ow2.weblab.content.api.ContentWriter;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabNotYetImplementedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.rdf.Value;
import org.purl.dc.elements.DublinCoreAnnotator;

public class WebDAVContentManager
implements ContentReader,
ContentWriter {
    public Log logger = LogFactory.getLog(WebDAVContentManager.class);
    public static final String WEBDAV_PROPERTY_FILE = "webdavContentManager.properties";
    public static final String WEBDAV_TMP_FOLDER_PATH = "webdav.tmpFolder";
    public static final String WEBDAV_HOST = "webdav.host";
    public static final String WEBDAV_TIMEOUT = "webdav.timeout";
    public static final String WEBDAV_MAXHOSTCONNECTIONS = "webdav.maxHostConnections";
    public static final String WEBDAV_PASSWORD = "webdav.password";
    public static final String WEBDAV_USERNAME = "webdav.username";
    public static final String PREFIX = "weblab-";
    public static final String SUFFIX = ".content";
    public static int cpt = 0;
    private final String webdavHost;
    private final int webdavTimeOut;
    private final int webdavMaxHostConnections;
    private final String webdavUserName;
    private final String webdavPassword;
    private final File tmpFolder = new File(ContentManager.getPropertyValue((String)"webdavContentManager.properties", (String)"webdav.tmpFolder", (String)"/tmp"));

    public WebDAVContentManager() {
        try {
            FileUtils.forceMkdir((File)this.tmpFolder);
        }
        catch (IOException ioe) {
            throw new WebLabUncheckedException("Unable to create folder [" + this.tmpFolder + "].", (Throwable)ioe);
        }
        if (!this.tmpFolder.exists()) {
            throw new WebLabUncheckedException("Content folder [" + this.tmpFolder + "] does not exists or is not readable.");
        }
        if (!this.tmpFolder.canWrite()) {
            throw new WebLabUncheckedException("Cannot write in content folder [" + this.tmpFolder + "].");
        }
        if (this.tmpFolder.isFile()) {
            throw new WebLabUncheckedException("Content folder [" + this.tmpFolder + "] is a File instead of a directory.");
        }
        this.logger.info((Object)("webdav.tmpFolder=" + this.tmpFolder.getAbsolutePath()));
        String host = ContentManager.getPropertyValue((String)WEBDAV_PROPERTY_FILE, (String)WEBDAV_HOST, null);
        this.webdavHost = !host.endsWith("/") ? host + '/' : host;
        this.logger.info((Object)("webdav.host=" + this.webdavHost));
        this.webdavTimeOut = Integer.parseInt(ContentManager.getPropertyValue((String)WEBDAV_PROPERTY_FILE, (String)WEBDAV_TIMEOUT, (String)Integer.toString(30000)));
        this.webdavMaxHostConnections = Integer.parseInt(ContentManager.getPropertyValue((String)WEBDAV_PROPERTY_FILE, (String)WEBDAV_MAXHOSTCONNECTIONS, (String)Integer.toString(20)));
        this.webdavUserName = ContentManager.getPropertyValue((String)WEBDAV_PROPERTY_FILE, (String)WEBDAV_PASSWORD, null);
        this.webdavPassword = ContentManager.getPropertyValue((String)WEBDAV_PROPERTY_FILE, (String)WEBDAV_USERNAME, null);
        this.logger.info((Object)("webdav.username=" + this.webdavUserName + " and " + WEBDAV_PASSWORD + " is set."));
        if (this.webdavHost == null) {
            throw new WebLabUncheckedException("Cannot initiate WebDAV host: host value is null");
        }
        if (this.webdavUserName == null || this.webdavPassword == null) {
            throw new WebLabUncheckedException("Cannot initiate WebDAV host: user and/or password value is null");
        }
    }

    private HttpClient initWebDAVClient() {
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.webdavHost);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setMaxConnectionsPerHost(hostConfig, this.webdavMaxHostConnections);
        params.setSoTimeout(this.webdavTimeOut);
        connectionManager.setParams(params);
        HttpClient clnt = new HttpClient((HttpConnectionManager)connectionManager);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.webdavUserName, this.webdavPassword);
        clnt.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
        clnt.setHostConfiguration(hostConfig);
        return clnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized URI writeContent(InputStream content, Resource resource) throws WebLabCheckedException {
        this.logger.debug((Object)("Saving content on WebDAV host [" + this.webdavHost + "]"));
        HttpClient client = this.initWebDAVClient();
        Class<WebDAVContentManager> clazz = WebDAVContentManager.class;
        synchronized (WebDAVContentManager.class) {
            Object annotator;
            Value mime;
            URI destURI = URI.create(this.webdavHost + PREFIX + cpt++ + '@' + System.currentTimeMillis() + SUFFIX);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.logger.debug((Object)("Destination URI on WebDAV host [" + destURI + "]"));
            PutMethod put = new PutMethod(destURI.toString());
            if (resource != null && (mime = (annotator = new DublinCoreAnnotator(resource)).readFormat()) != null && mime.hasValue()) {
                this.logger.debug((Object)("Content mime type [" + (String)mime.firstTypedValue() + "]"));
                put.setRequestHeader("content-type", (String)mime.firstTypedValue());
            }
            put.setRequestEntity((RequestEntity)new InputStreamRequestEntity(content));
            try {
                client.executeMethod((HttpMethod)put);
                put.checkSuccess();
                annotator = new URI(put.getURI().getURI());
                return annotator;
            }
            catch (URISyntaxException urie) {
                throw new WebLabCheckedException("Cannot create a valid from the WebDav", (Throwable)urie);
            }
            catch (HttpException httpe) {
                throw new WebLabCheckedException("Cannot save content: PUT method failure on WebDAV server [" + this.webdavHost + "]: " + httpe.getMessage(), (Throwable)httpe);
            }
            catch (IOException ioe) {
                throw new WebLabCheckedException("Cannot save content: I/O error while writing content on WebDAV server [" + this.webdavHost + "]: " + ioe.getMessage(), (Throwable)ioe);
            }
            catch (DavException de) {
                throw new WebLabCheckedException("WebDAV error while saving on [" + destURI + "]: " + de.getMessage(), (Throwable)de);
            }
            finally {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
    }

    public URI writeExposedContent(InputStream content, Resource resource) throws WebLabCheckedException {
        throw new WebLabNotYetImplementedException("writeExposedContent method not yet implemented...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File readContent(URI destUri) throws WebLabCheckedException {
        File out;
        if (!destUri.toString().contains(this.webdavHost)) {
            throw new WebLabCheckedException("Cannot read content [" + destUri + "]. The host is unknown.");
        }
        this.logger.debug((Object)("Getting content [" + destUri + "] from WebDAV."));
        HttpClient client = this.initWebDAVClient();
        try {
            out = File.createTempFile("webDAV", SUFFIX, this.tmpFolder);
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to create temp file in " + this.tmpFolder + " for " + destUri, (Throwable)ioe);
        }
        GetMethod get = new GetMethod(destUri.toString());
        try {
            client.executeMethod((HttpMethod)get);
            if (get.getStatusCode() != 200) {
                throw new WebLabCheckedException("Cannot read content: GET method failure for content [" + destUri + "] : " + get.getStatusCode() + " '" + get.getStatusText() + "'");
            }
            InputStream inStream = get.getResponseBodyAsStream();
            try {
                FileUtils.copyInputStreamToFile((InputStream)inStream, (File)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }
        catch (HttpException e) {
            throw new WebLabCheckedException("Cannot read content: GET method failure for content [" + destUri + "] on WebDAV server [" + this.webdavHost + "]", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Cannot read content: I/O error while copying [" + destUri + "] from WebDAV server [" + this.webdavHost + "] to local File [" + out + "].", (Throwable)e);
        }
        return out;
    }
}

