/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 CASSIDIAN an EADS Company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
package org.ow2.weblab.components.client.config.loader;

import java.io.File;

import org.ow2.weblab.components.client.config.ServiceConfigMap;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SpringBeanConfigLoader extends ConfigLoader {

	private static final String DEFAULT_CONFIGURATION_FILE = "webLabClient.xml";
	private static final String DEFAULT_CONFIG_BEAN = "servicesConfig";

	private XmlBeanFactory factory;

	public SpringBeanConfigLoader() {
		Resource r = new ClassPathResource(DEFAULT_CONFIGURATION_FILE);
		if (!r.exists()) {
			// let's try a workaround
			r = new FileSystemResource(new File(DEFAULT_CONFIGURATION_FILE));
			if (!r.exists()) {
				// well, that's not cool
				throw new WebLabUncheckedException("Cannot instanciate ConfigLoader from WebLabClient. Resource [" + r.getFilename() + "] is not acessible.");
			}
		}
		factory = new XmlBeanFactory(r);
	}

	@Override
	public ServiceConfigMap loadConfig() {
		return factory.getBean(DEFAULT_CONFIG_BEAN, ServiceConfigMap.class);
	}

}
