/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.components.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.components.client.WebLabService;
import org.ow2.weblab.components.client.config.ServiceConfigMap;
import org.ow2.weblab.components.client.config.loader.ConfigLoader;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.Analyser_Service;
import org.ow2.weblab.core.services.Configurable;
import org.ow2.weblab.core.services.Configurable_Service;
import org.ow2.weblab.core.services.Indexer;
import org.ow2.weblab.core.services.Indexer_Service;
import org.ow2.weblab.core.services.QueueManager;
import org.ow2.weblab.core.services.QueueManager_Service;
import org.ow2.weblab.core.services.ReportProvider;
import org.ow2.weblab.core.services.ReportProvider_Service;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.ResourceContainer_Service;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.Searcher_Service;
import org.ow2.weblab.core.services.SourceReader;
import org.ow2.weblab.core.services.SourceReader_Service;
import org.ow2.weblab.core.services.Trainable;
import org.ow2.weblab.core.services.Trainable_Service;

public class WebLabClient {
    private static final Log logger = LogFactory.getLog(WebLabClient.class);
    private static final String WEBLAB_WSDL_FILENAME = "services/WebLab.wsdl";
    private static URL webLabWSDL;
    private static ServiceConfigMap config;
    private static Map<String, WebLabService> uri2Service;

    private static void checkAndinit() {
        if (webLabWSDL == null) {
            ClassLoader cl = Resource.class.getClassLoader();
            if (cl == null) {
                throw new WebLabUncheckedException("Cannot instanciate class loader from WebLabClient.");
            }
            webLabWSDL = cl.getResource(WEBLAB_WSDL_FILENAME);
            if (webLabWSDL == null) {
                throw new WebLabUncheckedException("Cannot find the Weblab WSDL : [services/WebLab.wsdl].");
            }
        }
        if (uri2Service == null) {
            uri2Service = new HashMap<String, WebLabService>();
            ConfigLoader instance = ConfigLoader.getInstance();
            if (instance == null) {
                throw new WebLabUncheckedException("Cannot instanciate ConfigLoader from WebLabClient.");
            }
            config = instance.loadConfig();
            try {
                for (Map.Entry entry : config.entrySet()) {
                    WebLabClient.addService((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (WebLabCheckedException e) {
                throw new WebLabUncheckedException("WzebLab client configuration failed. " + e.getMessage(), (Throwable)e);
            }
        }
        logger.debug((Object)"WebLab client ready.");
    }

    protected static Map<String, String> getServiceurURLMap() {
        WebLabClient.checkAndinit();
        return config;
    }

    private static void checkParam(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkAndinit();
        if (userURI == null) {
            throw new WebLabCheckedException("User URI cannot be null.");
        }
        if (usageContext == null) {
            throw new WebLabCheckedException("Usage context cannot be null.");
        }
        if (serviceURI == null) {
            throw new WebLabCheckedException("Service URI cannot be null.");
        }
    }

    private static void setEndpointAddress(Object port, String newAddress) throws WebLabCheckedException {
        if (!(port instanceof BindingProvider)) {
            throw new WebLabCheckedException("Object: " + port + " doesn't appear to be a valid port. May be a webservice frfamewxork conflict.");
        }
        Map context = ((BindingProvider)port).getRequestContext();
        context.put("javax.xml.ws.service.endpoint.address", newAddress);
    }

    private static String getServiceLocalName(QName serviceQname) {
        String localName = serviceQname.getLocalPart();
        String first = localName.substring(0, 1).toLowerCase();
        return first + localName.substring(1);
    }

    private static WebLabService getService(String serviceURI) throws WebLabCheckedException {
        if (!config.containsKey(serviceURI.toString()) || !uri2Service.containsKey(serviceURI.toString())) {
            throw new WebLabCheckedException("The service [" + serviceURI + "] is not defined in WebLab client configuration.");
        }
        logger.debug((Object)("Getting service [" + serviceURI + "]."));
        WebLabService service = uri2Service.get(serviceURI.toString());
        return service;
    }

    public static URL getWeblabwsdl() {
        WebLabClient.checkAndinit();
        return webLabWSDL;
    }

    public static void addService(String uri, String urlString) throws WebLabCheckedException {
        WebLabClient.checkAndinit();
        try {
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new WebLabCheckedException("URL " + uri + " is invalid: " + e.getMessage(), (Throwable)e);
        }
        uri2Service.put(uri, new WebLabService(uri, urlString));
        logger.info((Object)("Adding service [" + uri + "]."));
    }

    public static Analyser getAnalyser(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(Analyser_Service.SERVICE) == null) {
            Analyser client = new Analyser_Service(webLabWSDL).getAnalyserPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(Analyser_Service.SERVICE));
            service.addClient(Analyser_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] Analyser interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(Analyser_Service.SERVICE)));
        return (Analyser)service.getClient(Analyser_Service.SERVICE);
    }

    public static Configurable getConfigurable(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(Configurable_Service.SERVICE) == null) {
            Configurable client = new Configurable_Service(webLabWSDL).getConfigurablePort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(Configurable_Service.SERVICE));
            service.addClient(Configurable_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] Configurable interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(Configurable_Service.SERVICE)));
        return (Configurable)service.getClient(Configurable_Service.SERVICE);
    }

    public static Indexer getIndexer(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(Indexer_Service.SERVICE) == null) {
            Indexer client = new Indexer_Service(webLabWSDL).getIndexerPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(Indexer_Service.SERVICE));
            service.addClient(Indexer_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] Indexer interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(Indexer_Service.SERVICE)));
        return (Indexer)service.getClient(Indexer_Service.SERVICE);
    }

    public static QueueManager getQueueManager(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(QueueManager_Service.SERVICE) == null) {
            QueueManager client = new QueueManager_Service(webLabWSDL).getQueueManagerPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(QueueManager_Service.SERVICE));
            service.addClient(QueueManager_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] QueueManager interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(QueueManager_Service.SERVICE)));
        return (QueueManager)service.getClient(QueueManager_Service.SERVICE);
    }

    public static ReportProvider getReportProvider(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(ReportProvider_Service.SERVICE) == null) {
            ReportProvider client = new ReportProvider_Service(webLabWSDL).getReportProviderPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(ReportProvider_Service.SERVICE));
            service.addClient(ReportProvider_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] QueueManager interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(QueueManager_Service.SERVICE)));
        return (ReportProvider)service.getClient(ReportProvider_Service.SERVICE);
    }

    public static ResourceContainer getResourceContainer(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(ResourceContainer_Service.SERVICE) == null) {
            ResourceContainer client = new ResourceContainer_Service(webLabWSDL).getResourceContainerPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(ResourceContainer_Service.SERVICE));
            service.addClient(ResourceContainer_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] ResourceContainer interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(ResourceContainer_Service.SERVICE)));
        return (ResourceContainer)service.getClient(ReportProvider_Service.SERVICE);
    }

    public static Searcher getSearcher(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(Searcher_Service.SERVICE) == null) {
            Searcher client = new Searcher_Service(webLabWSDL).getSearcherPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(Searcher_Service.SERVICE));
            service.addClient(Searcher_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] Searcher interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(Searcher_Service.SERVICE)));
        return (Searcher)service.getClient(Searcher_Service.SERVICE);
    }

    public static SourceReader getSourceReader(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(SourceReader_Service.SERVICE) == null) {
            SourceReader client = new SourceReader_Service(webLabWSDL).getSourceReaderPort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(SourceReader_Service.SERVICE));
            service.addClient(SourceReader_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] SourceReader interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(SourceReader_Service.SERVICE)));
        return (SourceReader)service.getClient(SourceReader_Service.SERVICE);
    }

    public static Trainable getTrainable(String userURI, String usageContext, String serviceURI) throws WebLabCheckedException {
        WebLabClient.checkParam(userURI, usageContext, serviceURI);
        WebLabService service = WebLabClient.getService(serviceURI);
        if (service.getClient(Trainable_Service.SERVICE) == null) {
            Trainable client = new Trainable_Service(webLabWSDL).getTrainablePort();
            WebLabClient.setEndpointAddress(client, service.getBaseUrl() + WebLabClient.getServiceLocalName(Trainable_Service.SERVICE));
            service.addClient(Trainable_Service.SERVICE, client);
        }
        logger.debug((Object)("Getting service [" + serviceURI + "] Trainable interface client @" + service.getBaseUrl() + WebLabClient.getServiceLocalName(Trainable_Service.SERVICE)));
        return (Trainable)service.getClient(Trainable_Service.SERVICE);
    }
}

