/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.components.client.config.loader;

import java.io.File;
import org.ow2.weblab.components.client.config.ServiceConfigMap;
import org.ow2.weblab.components.client.config.loader.ConfigLoader;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SpringBeanConfigLoader
extends ConfigLoader {
    private static final String DEFAULT_CONFIGURATION_FILE = "webLabClient.xml";
    private static final String DEFAULT_CONFIG_BEAN = "servicesConfig";
    private XmlBeanFactory factory;

    public SpringBeanConfigLoader() {
        ClassPathResource r = new ClassPathResource(DEFAULT_CONFIGURATION_FILE);
        if (!r.exists() && !(r = new FileSystemResource(new File(DEFAULT_CONFIGURATION_FILE))).exists()) {
            throw new WebLabUncheckedException("Cannot instanciate ConfigLoader from WebLabClient. Resource [" + r.getFilename() + "] is not acessible.");
        }
        this.factory = new XmlBeanFactory((Resource)r);
    }

    @Override
    public ServiceConfigMap loadConfig() {
        return (ServiceConfigMap)this.factory.getBean(DEFAULT_CONFIG_BEAN, ServiceConfigMap.class);
    }
}

