/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.FolderContentManager;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.model.content.BinaryContent;
import org.weblab_project.core.model.content.Content;
import org.weblab_project.core.uri.WebLabRI;

public class BinaryFolderContentManager
extends FolderContentManager {
    static Map<String, BinaryFolderContentManager> map = new HashMap<String, BinaryFolderContentManager>();

    protected BinaryFolderContentManager(String folderPath) throws WebLabUncheckedException {
        super(folderPath);
    }

    public BinaryContent getContent(String contentUri, int offset, int limit) throws WebLabCheckedException {
        byte[] tab;
        BinaryContent ret;
        block12: {
            WebLabRI wlRi = new WebLabRI(contentUri);
            ret = new BinaryContent();
            ret.setUri(contentUri);
            File file = this.getFileFromURI(wlRi);
            int effectiveLimit = limit;
            if (effectiveLimit == 0) {
                effectiveLimit = (int)file.length();
            }
            FileInputStream fs = null;
            tab = new byte[effectiveLimit];
            try {
                fs = new FileInputStream(file);
                if ((long)offset == fs.skip(offset)) {
                    ret.setLimit(fs.read(tab));
                    break block12;
                }
                throw new WebLabCheckedException("Unable to skip the right number of bytes.");
            }
            catch (IOException ioe) {
                throw new WebLabCheckedException("Unable to access file.", (Throwable)ioe);
            }
            finally {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException ioe) {
                        LogFactory.getLog(this.getClass()).warn((Object)"Error when closing stream.", (Throwable)ioe);
                    }
                }
            }
        }
        ret.setUri(ret.getUri());
        ret.setData(tab);
        ret.setOffset(offset);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(File file, File newFile) throws WebLabCheckedException {
        byte[] tab = new byte[this.bufferSize];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile, true));
                try {
                    int readed = bis.read(tab);
                    while (readed != -1) {
                        bos.write(tab, 0, readed);
                        readed = bis.read(tab);
                    }
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe) {
                        LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
                    }
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to copy file.", (Throwable)ioe);
        }
    }

    public void saveFile(File file, String uri) throws WebLabCheckedException {
        File newFile = this.getFileFromWLRi(uri);
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to create parent directory.");
        }
        this.copyFile(file, newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveContent(Content content) throws WebLabCheckedException {
        if (!(content instanceof BinaryContent)) {
            throw new WebLabCheckedException("Content '" + content.getUri() + "' is not an instance of BinaryContent of but a '" + content.getClass().getName() + "'.");
        }
        BinaryContent binaryContent = (BinaryContent)content;
        WebLabRI wlRi = new WebLabRI(binaryContent.getUri());
        File file = this.getFileFromURI(wlRi);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to create parent directory.");
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            try {
                raf.seek(binaryContent.getOffset());
                if (binaryContent.getLimit() == 0) {
                    binaryContent.setLimit(binaryContent.getData().length);
                }
                raf.write(binaryContent.getData(), 0, binaryContent.getLimit());
            }
            finally {
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    throw new WebLabCheckedException("Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("A I/O exception occurs.", (Throwable)ioe);
        }
    }

    public static BinaryFolderContentManager getInstance(String folderPath) throws WebLabUncheckedException {
        BinaryFolderContentManager binaryFolderContentManager = map.get(folderPath);
        if (binaryFolderContentManager == null) {
            binaryFolderContentManager = new BinaryFolderContentManager(folderPath);
            map.put(folderPath, binaryFolderContentManager);
        }
        return binaryFolderContentManager;
    }

    public static BinaryFolderContentManager getInstance() throws WebLabUncheckedException {
        return BinaryFolderContentManager.getInstance(FolderContentManager.getFolderValue("content.properties", "binarycontentpath", "binarycontent"));
    }
}

