/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.FolderContentManager;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.model.content.Content;
import org.weblab_project.core.model.content.TextContent;

public class TextFolderContentManager
extends FolderContentManager {
    static Map<String, TextFolderContentManager> map = new HashMap<String, TextFolderContentManager>();
    static final String CHARSET = "UTF-8";

    protected TextFolderContentManager(String folder) throws WebLabUncheckedException {
        super(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextContent getContent(String contentUri, int offset, int limit) throws WebLabCheckedException {
        int newLimit;
        TextContent ret = new TextContent();
        ret.setUri(contentUri);
        char[] fakeBuf = new char[offset];
        char[] buf = new char[limit];
        try {
            File file = this.getFileFromWLRi(contentUri);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, CHARSET);
            try {
                int readed = isr.read(fakeBuf);
                if (readed < offset) {
                    throw new IOException("Unable to move the offset to " + offset + " chars, only " + readed + " available.");
                }
                newLimit = isr.read(buf);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close reader.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to get content.", (Throwable)ioe);
        }
        ret.setUri(ret.getUri());
        ret.setOffset(offset);
        ret.setLimit(newLimit);
        ret.setData(new String(buf));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveString(String toBeSaved, String uri) throws WebLabCheckedException {
        File file = this.getFileFromWLRi(uri);
        if (file.exists()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Try to assign a string to an existing file. Older file deleted.");
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
            try {
                osw.write(toBeSaved);
                osw.flush();
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close writer.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to write content.", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveContent(Content content) throws WebLabCheckedException {
        if (!(content instanceof TextContent)) {
            throw new WebLabCheckedException("Content '" + content.getUri() + "' is not an instance of TextContent of but a '" + content.getClass().getName() + "'.");
        }
        TextContent textContent = (TextContent)content;
        int bufSize = 1024;
        File file = this.getFileFromWLRi(textContent.getUri());
        StringBuffer buf = new StringBuffer();
        char[] tab = new char[bufSize];
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, CHARSET);
            try {
                int readed = isr.read(tab);
                while (readed > 0) {
                    buf.append(tab, 0, readed);
                    readed = isr.read(tab);
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close reader.");
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to read the content to save.", (Throwable)ioe);
        }
        String begin = buf.substring(0, textContent.getOffset()) + textContent.getData();
        String end = buf.substring(textContent.getOffset() + textContent.getData().length());
        if (end != null) {
            begin = begin + end;
        }
        this.saveString(begin, content.getUri());
    }

    public static TextFolderContentManager getInstance(String folderPath) throws WebLabUncheckedException {
        TextFolderContentManager textFolderContentManager = map.get(folderPath);
        if (textFolderContentManager == null) {
            textFolderContentManager = new TextFolderContentManager(folderPath);
            map.put(folderPath, textFolderContentManager);
        }
        return textFolderContentManager;
    }

    public static TextFolderContentManager getInstance() throws WebLabUncheckedException {
        return TextFolderContentManager.getInstance(FolderContentManager.getFolderValue("content.properties", "textcontentpath", "textcontent"));
    }
}

