/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.helper.ResourceHelper;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.content.Content;
import org.weblab_project.core.properties.PropertiesLoader;
import org.weblab_project.core.uri.WebLabRI;

public abstract class FolderContentManager {
    protected String propertyKey = "folderpath";
    protected String propertyFileName = "content.properties";
    protected int bufferSize = 10000;
    protected File folder;
    public static final String SIMPLE_RESOURCE_RDF_HELPER = "org.weblab_project.core.helper.impl.JenaSingleResourceHelper";

    protected FolderContentManager(String folderPath) throws WebLabUncheckedException {
        this.folder = new File(folderPath);
        if (!FolderContentManager.checkFolder(this.folder)) {
            throw new WebLabUncheckedException("Folder '" + this.folder.getAbsolutePath() + "' is not a valid folder path");
        }
        LogFactory.getLog(this.getClass()).debug((Object)("Content provider uses folder : " + this.folder.getAbsolutePath()));
    }

    protected static boolean checkFolder(File folder) {
        if (folder.exists()) {
            return folder.isDirectory();
        }
        return folder.mkdirs();
    }

    protected File getFileFromWLRi(WebLabRI uri) {
        LogFactory.getLog(this.getClass()).debug((Object)("File path : " + this.folder.getAbsolutePath() + "/" + uri.toString().hashCode()));
        File newFile = new File(this.folder.getAbsolutePath() + "/" + uri.toString().hashCode());
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to create file. It may throw exception later.");
        }
        return newFile;
    }

    public File getFileFromWLRi(String uri) {
        return this.getFileFromWLRi(new WebLabRI(uri));
    }

    public File getNativeFileFromResource(Resource res) throws WebLabCheckedException {
        return this.getFileFromResourceAndPredicate(res, "http://weblab-project.org/core/model/property/processing/hasNativeContent");
    }

    public File getNormalisedFileFromResource(Resource res) throws WebLabCheckedException {
        return this.getFileFromResourceAndPredicate(res, "http://weblab-project.org/core/model/property/processing/hasNormalisedContent");
    }

    public File getFileFromResourceAndPredicate(Resource res, String pred) throws WebLabCheckedException {
        File file;
        ResourceHelper rh = RDFHelperFactory.getSpecificResourceHelper((Resource)res, (String)SIMPLE_RESOURCE_RDF_HELPER);
        List obj = rh.getRessOnPredSubj(res.getUri(), pred);
        if (obj.size() <= 0) {
            throw new WebLabCheckedException("No statement having '" + pred + "' as predicate found on resource '" + res.getUri() + "'.");
        }
        if (obj.size() == 1) {
            try {
                file = this.getFileFromWLRi((String)obj.get(0));
            }
            catch (Exception e) {
                throw new WebLabCheckedException("Unable to retrieve file from predicate '" + pred + "' and resource '" + res.getUri() + "'.", (Throwable)e);
            }
        }
        try {
            file = this.getFileFromWLRi((String)obj.get(0));
        }
        catch (Exception e) {
            throw new WebLabCheckedException("Unable to retrieve file from predicate '" + pred + "' and resource '" + res.getUri() + "'.", (Throwable)e);
        }
        LogFactory.getLog(this.getClass()).warn((Object)("Two statements having '" + pred + "' as predicate " + "found on resource '" + res.getUri() + "'. The fist one was used."));
        LogFactory.getLog(this.getClass()).debug((Object)obj);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new WebLabCheckedException("Unable to retrieve file from predicate '" + pred + "' and resource '" + res.getUri() + "'; File '" + file.getPath() + "' does not exist, is not a file or is not accessible.");
        }
        return file;
    }

    protected static String getFolderValue(String propertyPath, String propertyValue, String defaultValue) {
        String path;
        HashMap map;
        HashSet<String> props = new HashSet<String>();
        props.add(propertyValue);
        try {
            map = PropertiesLoader.loadProperties((String)propertyPath, props);
        }
        catch (WebLabUncheckedException wlue) {
            map = new HashMap(0);
        }
        if (map.containsKey(propertyValue)) {
            path = (String)map.get(propertyValue);
        } else {
            LogFactory.getLog(FolderContentManager.class).warn((Object)("Unable to load '" + propertyValue + "' from file '" + propertyPath + "'."));
            path = defaultValue;
        }
        LogFactory.getLog(FolderContentManager.class).debug((Object)("Loaded : '" + path + "' as content folder."));
        return path;
    }

    public abstract Content getContent(String var1, int var2, int var3) throws WebLabCheckedException;

    public abstract void saveContent(Content var1) throws WebLabCheckedException;

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }
}

