/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.extended.exception;

import org.apache.commons.logging.LogFactory;


/**
 * Weblab Unchecked Exception based on "Best Practices for Exception Handling" Logging is done once when it's created
 * 
 * @author Cassidian WebLab Team
 */
public class WebLabUncheckedException extends RuntimeException {

	private static final long serialVersionUID = 12L;

	/**
	 * @param message
	 *            The message
	 */
	public WebLabUncheckedException(final String message) {
		super(message);
		LogFactory.getLog(WebLabUncheckedException.class).error(message);
	}

	/**
	 * @param message
	 *            The message
	 * @param cause
	 *            The <code>Throwable</code> that causes the <code>RuntimeException</code>
	 */
	public WebLabUncheckedException(final String message, final Throwable cause) {
		super(message, cause);
		LogFactory.getLog(WebLabUncheckedException.class).error(message, cause);
	}

	/**
	 * @param cause
	 *            The <code>Throwable</code> that causes the <code>RuntimeException</code>
	 */
	public WebLabUncheckedException(final Throwable cause) {
		super(cause);
		LogFactory.getLog(WebLabUncheckedException.class).error(cause.getMessage(), cause);
	}

}
