/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.ow2.weblab.core.extended.exception.WebLabNotYetImplementedException;
import org.ow2.weblab.core.model.Coordinate;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.SpatialSegment;
import org.ow2.weblab.core.model.TemporalSegment;

public class SegmentComparator
implements Serializable,
Comparator<Segment> {
    private static final long serialVersionUID = 12L;

    @Override
    public int compare(Segment seg1, Segment seg2) {
        if (seg1 instanceof LinearSegment) {
            return SegmentComparator.compareLinear((LinearSegment)seg1, seg2);
        }
        if (seg2 instanceof LinearSegment) {
            return -SegmentComparator.compareLinear((LinearSegment)seg2, seg1);
        }
        if (seg1 instanceof TemporalSegment) {
            return SegmentComparator.compareTemporal((TemporalSegment)seg1, seg2);
        }
        if (seg2 instanceof TemporalSegment) {
            return -SegmentComparator.compareTemporal((TemporalSegment)seg2, seg1);
        }
        if (seg1 instanceof SpatialSegment) {
            return SegmentComparator.compareSpacial((SpatialSegment)seg1, seg2);
        }
        if (seg2 instanceof SpatialSegment) {
            return -SegmentComparator.compareSpacial((SpatialSegment)seg2, seg1);
        }
        throw new WebLabNotYetImplementedException("These Segments types " + seg1.getClass().getCanonicalName() + " " + seg2.getClass().getCanonicalName() + " are not yet handle in SegmentComparator");
    }

    private static int compareSpacial(SpatialSegment seg1, Segment seg2) {
        int toRet = seg2 instanceof SpatialSegment ? SegmentComparator.compareSpatials(seg1, (SpatialSegment)seg2) : -1;
        return toRet;
    }

    private static int compareSpatials(SpatialSegment seg1, SpatialSegment seg2) {
        float diff = seg1.getCoordinate().size() - seg2.getCoordinate().size();
        if (diff == 0.0f) {
            int i = 0;
            while (i < seg1.getCoordinate().size()) {
                diff = ((Coordinate)seg1.getCoordinate().get(i)).getX() - ((Coordinate)seg2.getCoordinate().get(i)).getX();
                if (diff != 0.0f || (diff = (float)(((Coordinate)seg1.getCoordinate().get(i)).getY() - ((Coordinate)seg2.getCoordinate().get(i)).getY())) != 0.0f) break;
                ++i;
            }
        }
        return (int)Math.signum(diff);
    }

    private static int compareTemporal(TemporalSegment seg1, Segment seg2) {
        int toRet = seg2 instanceof TemporalSegment ? SegmentComparator.compareTemporals(seg1, (TemporalSegment)seg2) : -1;
        return toRet;
    }

    private static int compareTemporals(TemporalSegment seg1, TemporalSegment seg2) {
        int diff = seg1.getStart() - seg2.getStart();
        int toRet = diff == 0 ? (int)Math.signum(seg1.getEnd() - seg2.getEnd()) : (int)Math.signum(diff);
        return toRet;
    }

    private static int compareLinear(LinearSegment seg1, Segment seg2) {
        int toRet = seg2 instanceof LinearSegment ? SegmentComparator.compareLinears(seg1, (LinearSegment)seg2) : -1;
        return toRet;
    }

    private static int compareLinears(LinearSegment seg1, LinearSegment seg2) {
        int diff = seg1.getStart() - seg2.getStart();
        int toRet = diff == 0 ? (int)Math.signum(seg1.getEnd() - seg2.getEnd()) : (int)Math.signum(diff);
        return toRet;
    }
}

