/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.factory;

import org.ow2.weblab.core.extended.exception.WebLabRISyntaxException;
import org.ow2.weblab.core.extended.exception.WebLabResourceCreationException;
import org.ow2.weblab.core.extended.factory.AbstractFactory;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;

public class MediaUnitFactory
extends AbstractFactory {
    protected static final char SEPARATOR = '-';

    private MediaUnitFactory() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static final <T extends MediaUnit> T createAndLinkMediaUnit(Resource res, Class<T> muClass) {
        MediaUnit mediaUnit;
        try {
            mediaUnit = (MediaUnit)muClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + muClass.getSimpleName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + muClass.getSimpleName(), iae);
        }
        try {
            mediaUnit.setUri(AbstractFactory.getUniqueWebLabRIFrom(res, true, false));
            AbstractFactory.addChild(mediaUnit, res, res);
        }
        catch (WebLabRISyntaxException wlrise) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + muClass.getSimpleName(), wlrise);
        }
        return (T)mediaUnit;
    }
}

