/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.jaxb.XMLStringCleaner;
import org.ow2.weblab.core.model.Resource;

public class WebLabMarshaller {
    private JAXBContext jc;

    private static JAXBElement<Resource> createJAXBElement(QName qname, Resource resource) {
        return new JAXBElement(qname, Resource.class, (Object)resource);
    }

    private static JAXBElement<Resource> createJAXBElement(String qNameLocalPart, Resource resource) {
        return new JAXBElement(new QName(qNameLocalPart), Resource.class, (Object)resource);
    }

    private static JAXBElement<Resource> createResourceJAXBElement(Resource resource) {
        return WebLabMarshaller.createJAXBElement(new QName("resource"), resource);
    }

    private void initJC() {
        if (this.jc == null) {
            try {
                this.jc = JAXBContext.newInstance((Class[])new Class[]{Resource.class});
            }
            catch (JAXBException jaxbe) {
                this.reset();
                throw new WebLabUncheckedException("Unable to initialise JAXBContext", jaxbe);
            }
        }
    }

    public void reset() {
        this.jc = null;
    }

    private Marshaller createMarshaller() {
        Marshaller marshaller;
        this.initJC();
        try {
            marshaller = this.jc.createMarshaller();
        }
        catch (JAXBException jaxbe) {
            this.reset();
            throw new WebLabUncheckedException("Unable to initialise marshaler", jaxbe);
        }
        try {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (PropertyException pe) {
            LogFactory.getLog(WebLabMarshaller.class).error((Object)"Unable to set property in marshaler", (Throwable)pe);
        }
        return marshaller;
    }

    private Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller;
        this.initJC();
        try {
            unmarshaller = this.jc.createUnmarshaller();
        }
        catch (JAXBException jaxbe) {
            this.reset();
            throw new WebLabUncheckedException("Unable to initialise unmarshaler", jaxbe);
        }
        return unmarshaller;
    }

    private void marshal(JAXBElement<?> jaxbElement, Writer writer, boolean checkXML) throws WebLabCheckedException {
        block18: {
            Marshaller marshaler = this.createMarshaller();
            try {
                if (checkXML) {
                    StringWriter sw = new StringWriter();
                    try {
                        try {
                            marshaler.marshal(jaxbElement, (Writer)sw);
                            writer.write(XMLStringCleaner.getXMLRecommendedString(sw.toString()));
                            break block18;
                        }
                        catch (IOException ioe) {
                            LogFactory.getLog(WebLabMarshaller.class).error((Object)"Unable to clean xml string; Trying with the input.", (Throwable)ioe);
                            marshaler.marshal(jaxbElement, writer);
                            try {
                                writer.flush();
                            }
                            catch (IOException ioe2) {
                                LogFactory.getLog(this.getClass()).warn((Object)"Unable to flush writer.");
                            }
                            break block18;
                        }
                        catch (JAXBException jaxbe) {
                            this.reset();
                            LogFactory.getLog(WebLabMarshaller.class).error((Object)"Unable to clean xml string; Trying with the input.", (Throwable)jaxbe);
                            Marshaller otherMarshaler = this.createMarshaller();
                            otherMarshaler.marshal(jaxbElement, writer);
                            try {
                                writer.flush();
                            }
                            catch (IOException ioe) {
                                LogFactory.getLog(this.getClass()).warn((Object)"Unable to flush writer.");
                            }
                            break block18;
                        }
                    }
                    finally {
                        try {
                            writer.flush();
                        }
                        catch (IOException ioe) {
                            LogFactory.getLog(this.getClass()).warn((Object)"Unable to flush writer.");
                        }
                    }
                }
                marshaler.marshal(jaxbElement, writer);
            }
            catch (JAXBException jaxbe) {
                this.reset();
                throw new WebLabCheckedException("Unable to marshal resource: " + jaxbElement.getValue() + "in writer: " + writer, jaxbe);
            }
        }
    }

    public <T extends Resource> T unmarshal(File file, Class<T> resourceClass) throws WebLabCheckedException {
        T res;
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                res = this.unmarshal(fis, resourceClass);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new WebLabCheckedException("Unable to read from file: '" + file.getAbsolutePath() + "'.", fnfe);
        }
        return res;
    }

    public <T extends Resource> T unmarshal(InputStream stream, Class<T> resourceClass) throws WebLabCheckedException {
        InputStreamReader isr;
        try {
            isr = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebLabCheckedException("UTF-8 not supported! Unable to marshall resource", uee);
        }
        return this.unmarshal(isr, resourceClass);
    }

    public <T extends Resource> T unmarshal(Reader reader, Class<T> resourceClass) throws WebLabCheckedException {
        Resource res;
        Unmarshaller unmarshaler = this.createUnmarshaller();
        try {
            JAXBElement jaxbElement = unmarshaler.unmarshal((Source)new StreamSource(reader), resourceClass);
            res = (Resource)jaxbElement.getValue();
            if (!resourceClass.isInstance(res)) {
                throw new ClassCastException("Unable to cast the unmarshaled Resource into a " + resourceClass.getName());
            }
            resourceClass.cast(res);
        }
        catch (JAXBException jaxbe) {
            this.reset();
            throw new WebLabCheckedException(jaxbe);
        }
        catch (ClassCastException cce) {
            throw new WebLabCheckedException(cce);
        }
        return (T)res;
    }

    public void marshalResource(Resource resource, File file) throws WebLabCheckedException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                this.marshalResource(resource, fos);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new WebLabCheckedException("Unable to marshal resource in file: '" + file.getAbsolutePath() + "'.", fnfe);
        }
    }

    public void marshalResource(Resource resource, OutputStream stream) throws WebLabCheckedException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
            this.marshalResource(resource, osw);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebLabCheckedException("UTF-8 not supported! Unable to marshall resource", uee);
        }
    }

    public void marshalResource(Resource resource, Writer writer) throws WebLabCheckedException {
        this.marshal(WebLabMarshaller.createResourceJAXBElement(resource), writer, false);
    }

    public void marshalResource(Resource resource, Writer writer, boolean checkXML) throws WebLabCheckedException {
        this.marshal(WebLabMarshaller.createResourceJAXBElement(resource), writer, checkXML);
    }

    public void marshal(Resource resource, Writer writer, QName qname) throws WebLabCheckedException {
        this.marshal(WebLabMarshaller.createJAXBElement(qname, resource), writer, false);
    }

    public void marshal(Resource resource, Writer writer, String qnameLocalPart) throws WebLabCheckedException {
        this.marshal(WebLabMarshaller.createJAXBElement(qnameLocalPart, resource), writer, false);
    }

    public boolean setMarshallerProperty(String key, Object value) {
        boolean set;
        Marshaller marshaler = this.createMarshaller();
        try {
            marshaler.setProperty(key, value);
            set = true;
        }
        catch (PropertyException pe) {
            set = false;
            LogFactory.getLog(WebLabMarshaller.class).error((Object)"Unable to set property in Marshaller", (Throwable)pe);
        }
        return set;
    }

    public boolean setUnmarshallerProperty(String key, Object value) {
        boolean set;
        Unmarshaller unmarshaler = this.createUnmarshaller();
        try {
            unmarshaler.setProperty(key, value);
            set = true;
        }
        catch (PropertyException pe) {
            set = false;
            LogFactory.getLog(WebLabMarshaller.class).error((Object)"Unable to set property in Unmarshaller", (Throwable)pe);
        }
        return set;
    }
}

