/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.util;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PoKUtil {
    private static final String START_ELEMENT = "<data>";
    private static final String END_ELEMENT = "</data>";

    private PoKUtil() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static String getPoKData(PieceOfKnowledge pok) {
        if (pok.getData() == null) {
            return "";
        }
        Element el = (Element)pok.getData();
        if (el.getFirstChild() == null) {
            return "";
        }
        boolean rdfRDFFound = false;
        StringBuilder sb = new StringBuilder();
        NodeList nodes = el.getChildNodes();
        int k = 0;
        while (k < nodes.getLength()) {
            Node domElement = nodes.item(k);
            if (domElement.getNodeType() != 3 || domElement.getNodeValue().trim().length() != 0) {
                if (domElement.getNodeType() == 3) {
                    throw new WebLabUncheckedException("PieceOfKnowledge contains a text node. Is it really valid RDF/XML?");
                }
                if (rdfRDFFound) {
                    throw new WebLabUncheckedException("PieceOfKnowledge contains a least a node in addition to a rdf:RDF one. It is not allowed in RDF/XML.");
                }
                String fullName = String.valueOf(domElement.getNamespaceURI()) + domElement.getLocalName();
                if (fullName.compareToIgnoreCase("http://www.w3.org/1999/02/22-rdf-syntax-ns#rdf") == 0) {
                    try {
                        sb.append(PoKUtil.extractRDFXML(domElement));
                    }
                    catch (TransformerException te) {
                        throw new WebLabUncheckedException("Unable to transform data field into a String. PieceOfKnowledge is corrupted!", te);
                    }
                    rdfRDFFound = true;
                } else if (fullName.compareToIgnoreCase("http://www.w3.org/1999/02/22-rdf-syntax-ns#description") == 0) {
                    try {
                        sb.append(PoKUtil.extractRDFXML(domElement));
                    }
                    catch (TransformerException te) {
                        throw new WebLabUncheckedException("Unable to transform data field into a String. PieceOfKnowledge is corrupted!", te);
                    }
                } else {
                    throw new WebLabUncheckedException("PieceOfKnowledge contains a least a non rdf node. It is not allowed in RDF/XML.");
                }
            }
            ++k;
        }
        return sb.toString();
    }

    private static String extractRDFXML(Node domElement) throws TransformerException {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("encoding", "UTF-8");
        trans.setOutputProperty("indent", "true");
        StringWriter strW = new StringWriter();
        trans.transform(new DOMSource(domElement), new StreamResult(strW));
        return strW.toString();
    }

    public static void setPoKData(PieceOfKnowledge pok, String pokStr, boolean strict) throws WebLabCheckedException {
        String tmp = (START_ELEMENT + pokStr.trim() + END_ELEMENT).replaceAll(">\\s+<", "><");
        DOMResult domRes = new DOMResult();
        StringReader strW = new StringReader(tmp);
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(new StreamSource(strW), domRes);
        }
        catch (TransformerConfigurationException tce) {
            throw new WebLabUncheckedException(tce);
        }
        catch (TransformerException te) {
            throw new WebLabCheckedException("Unvalid String parameter:'" + tmp + "'.", te);
        }
        pok.setData((Object)((Document)domRes.getNode()).getDocumentElement());
        if (strict) {
            PoKUtil.getPoKData(pok);
        }
    }

    public static void setPoKData(PieceOfKnowledge pok, String pokStr) throws WebLabCheckedException {
        PoKUtil.setPoKData(pok, pokStr, true);
    }
}

