/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.util;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.Text;

public class TextUtil {
    private TextUtil() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static String getSegmentText(Text text, LinearSegment segment) throws WebLabCheckedException {
        if (text != null && segment != null) {
            if (text.isSetSegment() && text.getSegment().contains(segment)) {
                String temp = text.getContent();
                if (temp != null) {
                    if (temp.length() >= segment.getEnd()) {
                        return temp.substring(segment.getStart(), segment.getEnd());
                    }
                    throw new WebLabCheckedException("Segment (" + segment.getUri() + ") ends after of content of Text: " + text.getUri() + ".");
                }
                throw new WebLabCheckedException("Content is null in Text: " + text.getUri());
            }
            throw new WebLabCheckedException("Text (" + text.getUri() + ") is not the parent of Segment: " + segment.getUri() + ".");
        }
        throw new WebLabCheckedException("Text (" + text + ") or Segment (" + segment + ") were null.");
    }
}

