/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.extended.exception;

/**
 * <code>WebLabUncheckedException</code> to be thrown when an error occurs in <code>Resource</code> creation.
 * 
 * @author Cassidian WebLab Team
 */
public class WebLabResourceCreationException extends WebLabUncheckedException {

	private static final long serialVersionUID = 121L;

	/**
	 * Default error message to be used.
	 */
	public static final String EXCEPTION = "Error when trying to instanciate: ";

	/**
	 * @param message
	 *            The message
	 * @param cause
	 *            The <code>Throwable</code> that causes the <code>RuntimeException</code>.
	 */
	public WebLabResourceCreationException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 *            The message
	 */
	public WebLabResourceCreationException(final String message) {
		super(message);
	}

	/**
	 * @param cause
	 *            The <code>Throwable</code> that causes the <code>RuntimeException</code>.
	 */
	public WebLabResourceCreationException(final Throwable cause) {
		super(cause);
	}

}
