/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.extended.ontologies;

/**
 * Just a useful class containing the <code>String</code> URIs of the RDF specification.
 * 
 * @author Cassidian WebLab Team
 * @date 2008-09-18
 */
public class RDFS {

	/**
	 * Constructors
	 * Do not use it.
	 */
	private RDFS() {
		throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
	}

	/**
	 * The namespace of all those classes and properties.
	 */
	public static final String NAMESPACE = "http://www.w3.org/2000/01/rdf-schema#";

	/**
	 * The class of literal values, e.g. textual strings and integers.
	 */
	public final static String LITERAL = RDFS.NAMESPACE + "Literal";

	/**
	 * The class resource, everything.
	 */
	public final static String RESOURCE = RDFS.NAMESPACE + "Resource";

	/**
	 * The class of classes.
	 */
	public final static String CLASS = RDFS.NAMESPACE + "Class";

	/**
	 * The class of RDF datatypes.
	 */
	public final static String DATATYPE = RDFS.NAMESPACE + "Datatype";

	/**
	 * The class of RDF containers.
	 */
	public final static String CONTAINER = RDFS.NAMESPACE + "Container";

	/**
	 * The class of container membership properties, rdf:_1, rdf:_2, ..., all of which are sub-properties of 'member'.
	 */
	public final static String CONTAINER_MEMBERSHIP_PROPERTY = RDFS.NAMESPACE + "ContainerMembershipProperty	";

	/**
	 * The subject is a subclass of a class.
	 */
	public final static String SUB_CLASS_OF = RDFS.NAMESPACE + "subClassOf";

	/**
	 * The subject is a subproperty of a property.
	 */
	public final static String SUB_PROPERTY_OF = RDFS.NAMESPACE + "subPropertyO";

	/**
	 * A domain of the subject property.
	 */
	public final static String DOMAIN = RDFS.NAMESPACE + "domain";

	/**
	 * A range of the subject property.
	 */
	public final static String RANGE = RDFS.NAMESPACE + "range";

	/**
	 * A human-readable name for the subject.
	 */
	public final static String LABEL = RDFS.NAMESPACE + "label";

	/**
	 * A description of the subject resource.
	 */
	public final static String COMMENT = RDFS.NAMESPACE + "comment";

	/**
	 * A member of the subject resource.
	 */
	public final static String MEMBER = RDFS.NAMESPACE + "member";

	/**
	 * Further information about the subject resource.
	 */
	public final static String SEE_ALSO = RDFS.NAMESPACE + "seeAlso";

	/**
	 * The definition of the subject resource.
	 */
	public final static String IS_DEFINED_BY = RDFS.NAMESPACE + "isDefinedBy";

}
