/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.extended.ontologies;

import org.ow2.weblab.core.model.Resource;


/**
 * @author Cassidian WebLab Team
 * @date 2008-05-07
 * 
 * @deprecated This class has been split into three files to better reflect the ontologies of Model
 * @see WebLabModel
 * @see WebLabProcessing
 * @see WebLabRetrieval
 */
@Deprecated
public final class WebLab {

	/**
	 * Constructors Do not use it.
	 */
	private WebLab() {
		throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
	}

	// Base URIs

	/**
	 * http://weblab.ow2.org/core/1.2/ontology/model#
	 */
	public final static String MODEL_NAMESPACE = WebLabModel.NAMESPACE;

	/**
	 * http://weblab.ow2.org/core/1.2/ontology/model#
	 */
	public final static String CLASS_NAMESPACE = WebLabModel.NAMESPACE;

	/**
	 * The base URI of the WebLab Resources Retrieval properties.
	 * http://weblab.ow2.org/core/1.2/ontology/retrieval#
	 */
	public final static String RETRIEVAL_PROPERTY_NAMESPACE = WebLabRetrieval.NAMESPACE;

	/**
	 * The base URI of the WebLab Resources Processing properties.
	 * http://weblab.ow2.org/core/1.2/ontology/processing#
	 */
	public final static String PROCESSING_PROPERTY_NAMESPACE = WebLabProcessing.NAMESPACE;

	/**
	 * The base URI of the WebLab structure properties.
	 * http://weblab.ow2.org/core/1.2/ontology/model#
	 */
	public final static String STRUCTURE_NAMESPACE = WebLabModel.NAMESPACE;

	// Structure properties

	/**
	 * Links a MediaUnit to one of its Segment.
	 */
	public final static String HAS_SEGMENT = WebLabModel.HAS_SEGMENT;

	/**
	 * Links a Segment to its parent MediaUnit.
	 * 
	 * @Warning Should not exits anymore (since 1.2)
	 */
	@Deprecated
	public final static String IN_MEDIA_UNIT = WebLab.STRUCTURE_NAMESPACE + "inMediaUnit";

	/**
	 * Links a ComposedUnit to one of its sub MediaUnit.
	 * 
	 * @Warning Should not exits anymore (since 1.2)
	 */
	@Deprecated
	public final static String HAS_MEDIA_UNIT = WebLab.STRUCTURE_NAMESPACE + "hasMediaUnit";

	/**
	 * Links a MediaUnit to its parent ComposedUnit.
	 * 
	 * @Warning Should not exits anymore (since 1.2)
	 */
	@Deprecated
	public final static String IN_COMPOSED_UNIT = WebLab.STRUCTURE_NAMESPACE + "inComposedUnit";

	/**
	 * Links a Resource to one of its Annotation.
	 */
	public final static String HAS_ANNOTATION = WebLabModel.HAS_ANNOTATION;

	/**
	 * Links an Annotation to its parent Resource.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String IN_RESOURCE_ANNOTATION = WebLab.STRUCTURE_NAMESPACE + "inResourceAnnotation";

	/**
	 * Links a Resource to one of its LowLevelDescriptor.
	 */
	public final static String HAS_LOW_LEVEL_DESCRIPTOR = WebLabModel.HAS_LOW_LEVEL_DESCRIPTOR;

	/**
	 * Links an LowLevelDescriptor to its parent Resource.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String IN_RESOURCE_LLD = WebLab.STRUCTURE_NAMESPACE + "inResourceLLD";

	/**
	 * Links a ComposedResource one of its Resource.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String HAS_RESOURCE = WebLab.STRUCTURE_NAMESPACE + "hasResource";

	/**
	 * Links a Resource to one of its parent ComposedResource.
	 */
	public final static String IN_COMPOSED_RESOURCE = WebLabModel.IN_COMPOSED_RESOURCE;

	/**
	 * Links a ResultSet to one of its Resource result.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String HAS_RESOURCE_RESULT = WebLab.STRUCTURE_NAMESPACE + "hasResourceResult";

	/**
	 * Links a Resource to one of its parent ResultSet.
	 */
	public final static String IN_RESULT_SET_RESOURCE = WebLabModel.IN_RESULT_SET;

	/**
	 * Links a ResultSet its PieceOfKnowledge result.
	 */
	public final static String HAS_POK_RESULT = WebLabModel.HAS_POK;

	/**
	 * Links a Hit to one of its parent ResultSet.
	 */
	public final static String IN_RESULT_SET_HIT = WebLabRetrieval.IN_RESULT_SET_HIT;

	/**
	 * Links a PieceOfKnowldege to one of its parent ResultSet.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String IN_RESULT_SET_POK = WebLab.STRUCTURE_NAMESPACE + "inResultSetPoK";

	/**
	 * Links a ComposedQuery one of its Query.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String HAS_QUERY_IN_COMPOSED = WebLab.STRUCTURE_NAMESPACE + "hasQuery";

	/**
	 * Links a Query to one of its parent ComposedQuery.
	 */
	public final static String IN_COMPOSED_QUERY = WebLabModel.IN_COMPOSED_QUERY;

	/**
	 * Links a SimilarityQuery to one of its Resource sample.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String HAS_RESOURCE_SIM_QUERY = WebLab.STRUCTURE_NAMESPACE + "hasResourceSimQuery";

	/**
	 * Links a Resource to one of its parent SimilarityQuery.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String IN_SIMILARITY_QUERY = WebLab.STRUCTURE_NAMESPACE + "inSimilarityQuery";

	// Processing properties

	/**
	 * Links a media unit to its native content.
	 */
	public final static String HAS_NATIVE_CONTENT = WebLabProcessing.HAS_NATIVE_CONTENT;

	/**
	 * Links a media unit to its normalised content.
	 */
	public final static String HAS_NORMALISED_CONTENT = WebLabProcessing.HAS_NORMALISED_CONTENT;

	/**
	 * Links a media unit result of an automatic (translation, summarisation,
	 * transcription) process from a source resource.
	 */
	public final static String IS_GENERATED_FROM = WebLabProcessing.IS_GENERATED_FROM;

	/**
	 * Indicates the service that has produced automatically or
	 * semi-automatically the resource
	 */
	public final static String IS_PRODUCED_BY = WebLabProcessing.IS_PRODUCED_BY;

	/**
	 * Indicates the service that has updated automatically or
	 * semi-automatically the resource.
	 */
	public final static String HAS_BEEN_UPDATED_BY = WebLabProcessing.HAS_BEEN_UPDATED_BY;

	/**
	 * Indicate the processing of this media unit can be ignored by a service.
	 */
	public final static String CAN_BE_IGNORED = WebLabProcessing.CAN_BE_IGNORED;

	/**
	 * Is exposed on a given protocol at a given address (for instance points to
	 * an URL).
	 */
	public final static String IS_EXPOSED_AS = WebLabProcessing.IS_EXPOSED_AS;

	/**
	 * Refers to an given instance. It might be an existing instance from an
	 * Ontology or a instance created in the Document or Text Annotation.
	 */
	public final static String REFERS_TO = WebLabProcessing.REFERS_TO;

	/**
	 * Whether or not is the instance extracted a candidate instance.
	 */
	public final static String IS_CANDIDATE = WebLabProcessing.IS_CANDIDATE;

	/**
	 * Gives the number of bytes of the original file crawled.
	 */
	public final static String HAS_ORIGINAL_FILE_SIZE = WebLabProcessing.HAS_ORIGINAL_FILE_SIZE;

	/**
	 * Gives the name of original file crawled.
	 */
	public final static String HAS_ORIGINAL_FILE_NAME = WebLabProcessing.HAS_ORIGINAL_FILE_NAME;

	/**
	 * Gives the date when the Document where crawled.
	 */
	public final static String HAS_GATHERING_DATE = WebLabProcessing.HAS_GATHERING_DATE;

	/**
	 * Gives the stem for a text.
	 * 
	 * @warning Should not exists since 1.2
	 */
	@Deprecated
	public final static String HAS_STEM = WebLab.PROCESSING_PROPERTY_NAMESPACE + "hasStem";

	// Retrieval

	// RDF classes
	/**
	 * A hit describes media document properties corresponding to a request.
	 */
	public final static String HIT = WebLabRetrieval.HIT;

	/**
	 * A SearchOrder describe a search order requested by a user or a service.
	 */
	public final static String SEARCH_ORDER = WebLabRetrieval.SEARCH_ORDER;

	// Properties

	/**
	 * Links a ResultSet to the Query that has been used to retrieve the set of
	 * results.
	 */
	public final static String IS_RESULT_OF = WebLabRetrieval.IS_RESULT_OF;

	/**
	 * Provides the hit score of a given media unit regarding a given query in
	 * the case of a result collection returns by a search service.
	 */
	public final static String HAS_SCORE = WebLabRetrieval.HAS_SCORE;

	/**
	 * Provides the offset about the query in the case of a result set returns
	 * by a search service.
	 */
	public final static String HAS_QUERY_OFFSET = WebLabRetrieval.HAS_QUERY_OFFSET;

	/**
	 * Provides the rank of a given media unit regarding a given query in the
	 * case of a result collection returns by a search service.
	 */
	public final static String HAS_RANK = WebLabRetrieval.HAS_RANK;

	/**
	 * Links a ResultSet to one of its Hit.
	 */
	public final static String HAS_HIT = WebLabRetrieval.HAS_HIT;

	/**
	 * Provides the snippet of a given media unit regarding a given query in the
	 * case of a result set returns by a search service.
	 */
	public final static String HAS_DESCRIPTION = WebLabRetrieval.HAS_DESCRIPTION;

	/**
	 * Provides the snippet of a given media unit regarding a given query in the
	 * case of a result collection returns by a search service.
	 */
	public final static String IS_LINKED_TO = WebLabRetrieval.IS_LINKED_TO;

	/**
	 * Gives the total number of results to a given query.
	 */
	public final static String HAS_NUMBER_OF_RESULTS = WebLabRetrieval.HAS_NUMBER_OF_RESULTS;

	/**
	 * Gives the language of the query.
	 */
	public final static String IS_EXPRESSED_WITH = WebLabRetrieval.IS_EXPRESSED_WITH;

	/**
	 * Gives the query for this order.
	 * 
	 * @warning Not maintained
	 */
	@Deprecated
	public final static String HAS_QUERY = WebLab.RETRIEVAL_PROPERTY_NAMESPACE + "hasQuery";

	/**
	 * Gives the offset for the requested query for this order.
	 */
	public final static String HAS_EXPECTED_OFFSET = WebLabRetrieval.HAS_EXPECTED_OFFSET;

	/**
	 * Gives the limit for the requested query for this order.
	 */
	public final static String HAS_EXPECTED_LIMIT = WebLabRetrieval.HAS_EXPECTED_LIMIT;

	// Methods

	/**
	 * Use this to get the WebLab ontology owl:Class URI corresponding to a java
	 * Class.
	 * 
	 * @warning Segment are not resources since 1.2
	 * @see #getClassFromUri(String)
	 * @param resourceClass
	 *            the java Class
	 * @return the ontology URI class
	 */
	public static String getUriFromClass(final Class<? extends Resource> resourceClass) {
		return WebLabModel.getUriFromResource(resourceClass);
	}

	/**
	 * Inverse method of {@link #getUriFromClass(Class)}.
	 * 
	 * @warning Segment are not resources since 1.2
	 * @see #getUriFromClass(Class)
	 * @param uri
	 *            The URI denoting a WebLab class in the ontology
	 * @return The java class
	 */
	public static Class<? extends Resource> getClassFromUri(final String uri) {
		final Class<?> clazz;
		try {
			clazz = WebLabModel.getClassFromUri(uri);
		} catch (final ClassNotFoundException cnfe) {
			throw new ClassCastException(uri + " does not represent an assignable Resource.");
		}
		return clazz.asSubclass(Resource.class);
	}

}
