/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
package org.ow2.weblab.core.extended.ontologies;


/**
 * Contains every properties that are defined in the processing.owl file of the WebLab model project.
 * 
 * This version includes relationships used for WebLab Resources processing.
 * 
 * @author WebLab Cassidian team
 * @date 2011-06-08
 */
public class WebLabProcessing {

	/**
	 * Constructors Do not use it.
	 */
	private WebLabProcessing() {
		throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
	}


	/**
	 * Namespace of the WebLab Processing ontology.
	 */
	public final static String NAMESPACE = "http://weblab.ow2.org/core/1.2/ontology/processing#";

	/**
	 * Preferred prefix of the WebLab Processing ontology.
	 */
	public final static String PREFERRED_PREFIX = "wlp";

	/*
	 * URI of the properties
	 */

	/**
	 * URI of the property hasBeenUpdatedBy. Links a resource to the service that has modified this resource.
	 */
	public final static String HAS_BEEN_UPDATED_BY = "http://weblab.ow2.org/core/1.2/ontology/processing#hasBeenUpdatedBy";

	/**
	 * URI of the property hasNativeContent. Links a media unit to its native content.
	 */
	public final static String HAS_NATIVE_CONTENT = "http://weblab.ow2.org/core/1.2/ontology/processing#hasNativeContent";

	/**
	 * URI of the property hasNormalisedContent. Links a media unit to its normalised content.
	 */
	public final static String HAS_NORMALISED_CONTENT = "http://weblab.ow2.org/core/1.2/ontology/processing#hasNormalisedContent";

	/**
	 * URI of the property isComposedByCluster. Link a ClusterLink with its two components clusters.
	 */
	public final static String IS_COMPOSED_BY_CLUSTER = "http://weblab.ow2.org/core/1.2/ontology/processing#isComposedByCluster";

	/**
	 * URI of the property isGeneratedFrom. Links a resource result of an automatic (translation, summarisation, transcription) process to its source resource.
	 */
	public final static String IS_GENERATED_FROM = "http://weblab.ow2.org/core/1.2/ontology/processing#isGeneratedFrom";

	/**
	 * URI of the property isShotOf. Links a shot Video to its source Video.
	 */
	public final static String IS_SHOT_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isShotOf";

	/**
	 * URI of the property isFrameOf. Links a frame Image to its source Video.
	 */
	public final static String IS_FRAME_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isFrameOf";

	/**
	 * URI of the property isSoundtrackOf. Links a soundtrack to its source Video.
	 */
	public final static String IS_SOUNDTRACK_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isSoundtrackOf";

	/**
	 * URI of the property isTranscriptOf. Links a transcript to its source (Image or Video MediaUnit).
	 */
	public final static String IS_TRANSCRIPT_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isTranscriptOf";

	/**
	 * URI of the property isTranslationOf. Links translated Text or LinearSegment to its source Text or LinearSegment.
	 */
	public final static String IS_TRANSLATION_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isTranslationOf";

	/**
	 * URI of the property isRecognitionOf. Links an extracted Text to its source Image.
	 */
	public final static String IS_RECOGNITION_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isRecognitionOf";

	/**
	 * URI of the property isSynthesisOf. Links a synthesized Audio unit to its source Text.
	 */
	public final static String IS_SYNTHESIS_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isSynthesisOf";

	/**
	 * URI of the property isSummaryOf. Links a summary to its source Text.
	 */
	public final static String IS_SUMMARY_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isSummaryOf";

	/**
	 * URI of the property isCleansingOf. Links a cleansed MediaUnit to its source MediaUnit.
	 */
	public final static String IS_CLEANSING_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isCleansingOf";

	/**
	 * URI of the property isDelimiterOfShotUnit. Links a segment to the shot MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_SHOT_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfShotUnit";

	/**
	 * URI of the property isDelimiterOfFrameUnit. Links a segment to the frame MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_FRAME_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfFrameUnit";

	/**
	 * URI of the property isDelimiterOfTranscriptUnit. Links a segment to the transcript MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_TRANSCRIPT_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfTranscriptUnit";

	/**
	 * URI of the property isDelimiterOfTranslationUnit. Links a segment to the translation MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_TRANSLATION_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfTranslationUnit";

	/**
	 * URI of the property isDelimiterOfRecognitionUnit. Links a segment to the recognition MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_RECOGNITION_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfRecognitionUnit";

	/**
	 * URI of the property isDelimiterOfSynthesisUnit. Links a segment to the synthesis MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_SYNTHESIS_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfSynthesisUnit";

	/**
	 * URI of the property isDelimiterOfSummaryUnit. Links a segment to the summary MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_SUMMARY_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfSummaryUnit";

	/**
	 * URI of the property isDelimiterOfCleansingUnit. Links a segment to the cleansing MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_CLEANSING_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfCleansingUnit";

	/**
	 * URI of the property isDelimiterOfSoundtrackUnit. Links a segment to the soundtrack MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF_SOUNDTRACK_UNIT = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOfSoundtrackUnit";

	/**
	 * URI of the property isDelimiterOf. Links a segment to the MediaUnit it represents.
	 */
	public final static String IS_DELIMITER_OF = "http://weblab.ow2.org/core/1.2/ontology/processing#isDelimiterOf";

	/**
	 * URI of the property isInCluster. Links a WebLab Document to a Cluster.
	 */
	public final static String IS_IN_CLUSTER = "http://weblab.ow2.org/core/1.2/ontology/processing#isInCluster";

	/**
	 * URI of the property isInClusterLink. Links a cluster to a ClusterLink.
	 */
	public final static String IS_INCLUSTER_LINK = "http://weblab.ow2.org/core/1.2/ontology/processing#isInClusterLink";

	/**
	 * URI of the property isProducedBy. Indicates the service that has produced automatically or semi-automatically the resource.
	 */
	public final static String IS_PRODUCED_BY = "http://weblab.ow2.org/core/1.2/ontology/processing#isProducedBy";

	/**
	 * URI of the property refersTo. Links a segment to an instance of a recognised entity (given its URI).
	 */
	public final static String REFERS_TO = "http://weblab.ow2.org/core/1.2/ontology/processing#refersTo";

	/**
	 * URI of the property isLocatedAt. Links a MediaUnit to the segment from which it has been produced.
	 */
	public final static String IS_LOCATED_AT = "http://weblab.ow2.org/core/1.2/ontology/processing#isLocatedAt";

	/**
	 * URI of the property canBeIgnored. Indicates whether or not a MediaUnit can be ignored by a service.
	 */
	public final static String CAN_BE_IGNORED = "http://weblab.ow2.org/core/1.2/ontology/processing#canBeIgnored";

	/**
	 * URI of the property hasClusterProximity. Value that corresponds to the proximity between the two clusters implied in a cluster link.
	 */
	public final static String HAS_CLUSTER_PROXIMITY = "http://weblab.ow2.org/core/1.2/ontology/processing#hasClusterProximity";

	/**
	 * URI of the property hasGatheringDate. Gives the date when the Document was gathered.
	 */
	public final static String HAS_GATHERING_DATE = "http://weblab.ow2.org/core/1.2/ontology/processing#hasGatheringDate";

	/**
	 * URI of the property hasOriginalFileName. Gives the name of the original file gathered.
	 */
	public final static String HAS_ORIGINAL_FILE_NAME = "http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileName";

	/**
	 * URI of the property hasOriginalFileSize. Gives the number of bytes of the original file gathered.
	 */
	public final static String HAS_ORIGINAL_FILE_SIZE = "http://weblab.ow2.org/core/1.2/ontology/processing#hasOriginalFileSize";

	/**
	 * URI of the property isCandidate. Indicates whether or not is the instance extracted a candidate instance.
	 */
	public final static String IS_CANDIDATE = "http://weblab.ow2.org/core/1.2/ontology/processing#isCandidate";

	/**
	 * URI of the property isExposedAs. Is exposed on a given protocol at a given address (for instance points to an URL).
	 */
	public final static String IS_EXPOSED_AS = "http://weblab.ow2.org/core/1.2/ontology/processing#isExposedAs";

	/*
	 * URI of the classes
	 */

	/**
	 * URI of the OWL class Cluster. A cluster is a set of resources that share some characteristics.
	 */
	public final static String CLUSTER = "http://weblab.ow2.org/core/1.2/ontology/processing#Cluster";

	/**
	 * URI of the OWL class ClusterLink. A link between exactly two clusters.
	 */
	public final static String CLUSTER_LINK = "http://weblab.ow2.org/core/1.2/ontology/processing#ClusterLink";

	/**
	 * URI of the OWL class Service. A service able to deal with WebLab resources.
	 */
	public final static String SERVICE = "http://weblab.ow2.org/core/1.2/ontology/processing#Service";

}
