/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
package org.ow2.weblab.core.extended.ontologies;


/**
 * Contains every properties that are defined in the retrieval.owl file of the WebLab model project.
 * 
 * This version includes relationships used for WebLab Resources retrieval.
 * 
 * @author WebLab Cassidian team
 * @date 2011-06-08
 */
public class WebLabRetrieval {

	/**
	 * Constructors Do not use it.
	 */
	private WebLabRetrieval() {
		throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
	}


	/**
	 * Namespace of the WebLab Retrieval ontology.
	 */
	public final static String NAMESPACE = "http://weblab.ow2.org/core/1.2/ontology/retrieval#";

	/**
	 * Preferred prefix of the WebLab Retrieval Ontology.
	 */
	public final static String PREFERRED_PREFIX = "wlr";

	
	
	
	/**
	 * URI of the property hasHit. Gives a hit for ResultSet.
	 */
	public final static String HAS_HIT = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasHit";

	/**
	 * URI of the property hasOrderedQuery. Gives a link to the requested query for this order.
	 */
	public final static String HAS_ORDERED_QUERY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasOrderedQuery";

	/**
	 * URI of the property inResultSetHit. Links a Hit to its ResultSet.
	 */
	public final static String IN_RESULT_SET_HIT = "http://weblab.ow2.org/core/1.2/ontology/retrieval#inResultSetHit";

	/**
	 * URI of the property isLinkedTo. Gives a link to resource for hit.
	 */
	public final static String IS_LINKED_TO = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo";

	/**
	 * URI of the property isResultOf. Links a ResultSet to the Query that has been used to retrieve the set of results.
	 */
	public final static String IS_RESULT_OF = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isResultOf";

	/**
	 * URI of the property hasDescription. Gives a description for a hit.
	 */
	public final static String HAS_DESCRIPTION = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasDescription";

	/**
	 * URI of the property hasExpectedLimit. Gives the limit for the requested query for this order.
	 */
	public final static String HAS_EXPECTED_LIMIT = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedLimit";

	/**
	 * URI of the property hasExpectedOffset. Gives the expected offset for the requested query for this order.
	 */
	public final static String HAS_EXPECTED_OFFSET = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedOffset";

	/**
	 * URI of the property hasNumberOfResults. Gives the total number of results for this result set.
	 */
	public final static String HAS_NUMBER_OF_RESULTS = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults";

	/**
	 * URI of the property hasQueryOffset. Provides the offset about the query in the case of a result set returns by a search service.
	 */
	public final static String HAS_QUERY_OFFSET = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasQueryOffset";

	/**
	 * URI of the property hasRank. Gives a rank for hit.
	 */
	public final static String HAS_RANK = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasRank";

	/**
	 * URI of the property hasScore. Gives a score for hit.
	 */
	public final static String HAS_SCORE = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasScore";

	/**
	 * URI of the property isExpressedWith. Gives the language of the query.
	 */
	public final static String IS_EXPRESSED_WITH = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isExpressedWith";

	/*
	 * URI of the classes
	 */
	
	/**
	 * URI of the OWL class Hit. A hit describes media document properties corresponding to a request.
	 */
	public final static String HIT = "http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit";

	/**
	 * URI of the OWL class SearchOrder. A SearchOrder describe a search order requested by a user or a service.
	 */
	public final static String SEARCH_ORDER = "http://weblab.ow2.org/core/1.2/ontology/retrieval#SearchOrder";


}
