/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.comparator;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.model.Coordinate;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.SpatialSegment;
import org.ow2.weblab.core.model.SpatioTemporalSegment;
import org.ow2.weblab.core.model.TemporalSegment;
import org.ow2.weblab.core.model.TrackSegment;

public class SegmentComparator
implements Serializable,
Comparator<Segment> {
    private static final long serialVersionUID = 121L;

    @Override
    public int compare(Segment seg1, Segment seg2) {
        if (seg1 == seg2) {
            return 0;
        }
        if (seg1.getClass().equals(seg2.getClass())) {
            return this.compareSameTypes(seg1, seg2);
        }
        return this.compareDifferentTypes(seg1, seg2);
    }

    private int compareDifferentTypes(Segment seg1, Segment seg2) {
        if (seg1.getClass().equals(LinearSegment.class)) {
            return -1;
        }
        if (seg2.getClass().equals(LinearSegment.class)) {
            return 1;
        }
        if (seg1.getClass().equals(TemporalSegment.class)) {
            return -1;
        }
        if (seg2.getClass().equals(TemporalSegment.class)) {
            return 1;
        }
        if (seg1.getClass().equals(SpatialSegment.class)) {
            return -1;
        }
        if (seg2.getClass().equals(SpatialSegment.class)) {
            return 1;
        }
        if (seg1.getClass().equals(SpatioTemporalSegment.class)) {
            return -1;
        }
        if (seg2.getClass().equals(SpatioTemporalSegment.class)) {
            return 1;
        }
        if (seg1.getClass().equals(TrackSegment.class)) {
            return -1;
        }
        if (seg2.getClass().equals(TrackSegment.class)) {
            return 1;
        }
        LogFactory.getLog(SegmentComparator.class).debug((Object)(seg1.getClass().getName() + " not defined. Comparison done through hashCode."));
        return Integer.signum(seg1.hashCode() - seg2.hashCode());
    }

    private int compareSameTypes(Segment seg1, Segment seg2) {
        if (seg1 instanceof LinearSegment) {
            LinearSegment lSeg1 = (LinearSegment)seg1;
            LinearSegment lSeg2 = (LinearSegment)seg2;
            int startComparison = Integer.signum(lSeg1.getStart() - lSeg2.getStart());
            if (startComparison == 0) {
                return Integer.signum(lSeg1.getEnd() - lSeg2.getEnd());
            }
            return startComparison;
        }
        if (seg1 instanceof TemporalSegment) {
            TemporalSegment tSeg1 = (TemporalSegment)seg1;
            TemporalSegment tSeg2 = (TemporalSegment)seg2;
            int startComparison = Integer.signum(tSeg1.getStart() - tSeg2.getStart());
            if (startComparison == 0) {
                return Integer.signum(tSeg1.getEnd() - tSeg2.getEnd());
            }
            return startComparison;
        }
        if (seg1 instanceof SpatioTemporalSegment) {
            SpatioTemporalSegment stSeg1 = (SpatioTemporalSegment)seg1;
            SpatioTemporalSegment stSeg2 = (SpatioTemporalSegment)seg2;
            int timestampComparison = Integer.signum(stSeg1.getTimestamp() - stSeg2.getTimestamp());
            if (timestampComparison == 0) {
                return this.compareCoordinates(stSeg1.getCoordinate(), stSeg2.getCoordinate());
            }
            return timestampComparison;
        }
        if (seg1 instanceof SpatialSegment) {
            SpatialSegment sSeg1 = (SpatialSegment)seg1;
            SpatialSegment sSeg2 = (SpatialSegment)seg2;
            return this.compareCoordinates(sSeg1.getCoordinate(), sSeg2.getCoordinate());
        }
        if (seg1 instanceof TrackSegment) {
            return this.compareTracks((TrackSegment)seg1, (TrackSegment)seg2);
        }
        LogFactory.getLog(SegmentComparator.class).debug((Object)(seg1.getClass().getName() + " not defined. Comparison done through hashCode."));
        return Integer.signum(seg1.hashCode() - seg2.hashCode());
    }

    private int compareTracks(TrackSegment seg1, TrackSegment seg2) {
        int sizeDifference = Integer.signum(seg1.getSegment().size() - seg2.getSegment().size());
        if (sizeDifference == 0 && !seg2.getSegment().isEmpty()) {
            int innerSegmentDifference;
            int cpt = 0;
            int size = seg2.getSegment().size();
            while ((innerSegmentDifference = this.compare((Segment)seg1.getSegment().get(cpt), (Segment)seg2.getSegment().get(cpt))) == 0 && ++cpt < size) {
            }
            return innerSegmentDifference;
        }
        return sizeDifference;
    }

    private int compareCoordinates(List<Coordinate> coordinate1, List<Coordinate> coordinate2) {
        int sizeDifference = Integer.signum(coordinate1.size() - coordinate2.size());
        if (sizeDifference == 0 && !coordinate2.isEmpty()) {
            int coordinateDifference;
            int cpt = 0;
            int size = coordinate1.size();
            do {
                if ((coordinateDifference = Float.compare(coordinate1.get(cpt).getX(), coordinate2.get(cpt).getX())) != 0) continue;
                coordinateDifference = Float.compare(coordinate1.get(cpt).getY(), coordinate2.get(cpt).getY());
            } while (coordinateDifference == 0 && ++cpt < size);
            return coordinateDifference;
        }
        return sizeDifference;
    }
}

