/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.factory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.uri.WebLabRI;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.LowLevelDescriptor;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.SimilarityQuery;
import org.ow2.weblab.core.model.TrackSegment;

abstract class AbstractFactory {
    protected static final Map<String, Set<String>> innerMap = Collections.synchronizedMap(new LinkedHashMap());

    AbstractFactory() {
    }

    protected static synchronized void cleanMapping(String uri) {
        Iterator<Map.Entry<String, Set<String>>> it = innerMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Set<String>> entry = it.next();
            if (!entry.getValue().contains(uri)) continue;
            it.remove();
        }
    }

    protected static synchronized Set<String> getUris(String key) {
        if (!innerMap.containsKey(key)) {
            for (Set<String> test : innerMap.values()) {
                if (!test.contains(key)) continue;
                return test;
            }
            return new HashSet<String>();
        }
        return innerMap.get(key);
    }

    protected static synchronized void setUris(String key, Set<String> uris) {
        while (innerMap.size() > 1000) {
            String fkey = innerMap.keySet().iterator().next();
            innerMap.remove(fkey);
        }
        innerMap.put(key, uris);
    }

    protected static synchronized Set<String> listUri(Resource resource) {
        return AbstractFactory.listUri(resource, false);
    }

    private static Set<String> listUri(String uri) {
        Set<String> buffered_uris = AbstractFactory.getUris(uri);
        return buffered_uris;
    }

    protected static synchronized Set<String> listUri(Segment segment) {
        Set<String> buffered_uris = AbstractFactory.listUri(segment.getUri());
        if (!buffered_uris.isEmpty()) {
            return buffered_uris;
        }
        Set<String> set = Collections.synchronizedSet(new HashSet());
        set.add(segment.getUri());
        if (segment instanceof TrackSegment) {
            TrackSegment ts = (TrackSegment)segment;
            for (Segment inner : ts.getSegment()) {
                set.addAll(AbstractFactory.listUri(inner));
            }
        }
        return set;
    }

    protected static synchronized Set<String> listUri(Resource resource, boolean force) {
        Set<String> buffered_uris = AbstractFactory.listUri(resource.getUri());
        if (!force && !buffered_uris.isEmpty()) {
            return buffered_uris;
        }
        Set<String> set = Collections.synchronizedSet(new HashSet());
        set.add(resource.getUri());
        if (resource instanceof Document) {
            Document doc = (Document)resource;
            if (doc.isSetMediaUnit()) {
                for (MediaUnit inner : doc.getMediaUnit()) {
                    set.addAll(AbstractFactory.listUri((Resource)inner));
                }
            }
            if (doc.isSetSegment()) {
                for (Segment s : doc.getSegment()) {
                    set.addAll(AbstractFactory.listUri(s));
                }
            }
        } else if (resource instanceof ComposedResource) {
            ComposedResource cr = (ComposedResource)resource;
            for (MediaUnit inner : cr.getResource()) {
                set.addAll(AbstractFactory.listUri((Resource)inner));
            }
        } else if (resource instanceof MediaUnit) {
            MediaUnit mu = (MediaUnit)resource;
            if (mu.isSetSegment()) {
                for (Segment s : mu.getSegment()) {
                    set.addAll(AbstractFactory.listUri(s));
                }
            }
        } else if (resource instanceof ResultSet) {
            ResultSet rs = (ResultSet)resource;
            if (rs.isSetPok()) {
                set.addAll(AbstractFactory.listUri((Resource)rs.getPok()));
            }
        } else if (resource instanceof ComposedQuery) {
            ComposedQuery cq = (ComposedQuery)resource;
            for (Query query : cq.getQuery()) {
                set.addAll(AbstractFactory.listUri((Resource)query));
            }
        } else if (resource instanceof SimilarityQuery) {
            SimilarityQuery sq = (SimilarityQuery)resource;
            for (Resource subresource : sq.getResource()) {
                set.addAll(AbstractFactory.listUri(subresource));
            }
        }
        if (resource.isSetAnnotation()) {
            for (Annotation a : resource.getAnnotation()) {
                set.addAll(AbstractFactory.listUri((Resource)a));
            }
        }
        if (resource.isSetDescriptor()) {
            for (LowLevelDescriptor lld : resource.getDescriptor()) {
                set.addAll(AbstractFactory.listUri((Resource)lld));
            }
        }
        AbstractFactory.setUris(resource.getUri(), set);
        return set;
    }

    protected static synchronized String createSegmentURIFor(Object segmentContainer) {
        if (segmentContainer instanceof Segment) {
            Segment segment = (Segment)segmentContainer;
            return AbstractFactory.createUniqueURIin(AbstractFactory.listUri(segment), true, false, segment.getUri());
        }
        if (segmentContainer instanceof Resource) {
            Resource resource = (Resource)segmentContainer;
            return AbstractFactory.createUniqueURIin(AbstractFactory.listUri(resource), true, false, resource.getUri());
        }
        throw new WebLabUncheckedException("Object of type " + segmentContainer.getClass() + " can not contain Segment.");
    }

    protected static synchronized String createUniqueURIFrom(Resource resource, boolean isChild, boolean isAnnotation) {
        return AbstractFactory.createUniqueURIin(AbstractFactory.listUri(resource), isChild, isAnnotation, resource.getUri());
    }

    protected static synchronized String createUniqueURIin(Set<String> uris, boolean isChild, boolean isAnnotation, String parentUri) {
        String ref = "webLabFactory";
        String res = "auto-parent";
        String template = "weblab://webLabFactory/auto-parent";
        if (isAnnotation) {
            template = parentUri.indexOf("#") != -1 ? parentUri + "-a" : parentUri + "#a";
        }
        if (isChild) {
            template = parentUri.indexOf("#") != -1 ? parentUri + "-" : parentUri + "#";
        }
        int i = uris.size() - 1;
        String uri = null;
        while (uri == null || uris.contains(uri)) {
            if (i + 1 == 0) {
                template = template + i + "_";
                i = 0;
            }
            uri = template + i++;
        }
        uris.add(uri);
        return new WebLabRI(uri).toString();
    }

    protected static synchronized void removeChild(MediaUnit mu, Resource parent, Resource root) {
        Set<String> uris = AbstractFactory.listUri(root);
        if (parent instanceof ComposedResource) {
            ComposedResource cr = (ComposedResource)parent;
            cr.getResource().remove(mu);
            uris.remove(mu.getUri());
        }
    }

    protected static synchronized void addAnnotation(Annotation annotation, Resource resource, Resource root) {
        resource.getAnnotation().add(annotation);
        AbstractFactory.listUri(root).add(annotation.getUri());
    }

    protected static synchronized void addSegment(Segment segment, MediaUnit parent, Resource root) {
        parent.getSegment().add(segment);
        AbstractFactory.listUri(root).add(segment.getUri());
    }

    protected static synchronized void addDescriptor(LowLevelDescriptor descriptor, Resource parent, Resource root) {
        parent.getDescriptor().add(descriptor);
        AbstractFactory.listUri(root).add(descriptor.getUri());
    }

    @Deprecated
    protected static synchronized void addChild(MediaUnit mu, Resource parent, Resource root) {
        Set<String> uris = AbstractFactory.listUri(root);
        if (parent instanceof ComposedResource) {
            ComposedResource cr = (ComposedResource)parent;
            cr.getResource().add(mu);
            uris.add(mu.getUri());
        } else if (parent instanceof Document) {
            Document doc = (Document)parent;
            doc.getMediaUnit().add(mu);
            uris.add(mu.getUri());
        } else {
            throw new WebLabUncheckedException("Unable to create a sub media unit on a: " + parent.getClass() + " needed " + Document.class + " or " + ComposedResource.class);
        }
    }

    protected static synchronized void addChild(MediaUnit mu, Document parent) {
        Set<String> uris = AbstractFactory.listUri((Resource)parent);
        parent.getMediaUnit().add(mu);
        uris.add(mu.getUri());
    }

    protected static synchronized Resource findParent(MediaUnit mu, Resource resource) {
        Document doc;
        if (resource instanceof ComposedResource) {
            ComposedResource cr = (ComposedResource)resource;
            if (cr.getResource().contains(mu)) {
                return resource;
            }
            for (Resource inner : cr.getResource()) {
                Resource r = AbstractFactory.findParent(mu, inner);
                if (r == null) continue;
                return r;
            }
        } else if (resource instanceof Document && (doc = (Document)resource).isSetMediaUnit() && doc.getMediaUnit().contains(mu)) {
            return resource;
        }
        return null;
    }

    protected static final synchronized String getUniqueWebLabRIFrom(Resource res, boolean isChild, boolean isAnnotation) {
        return AbstractFactory.createUniqueURIFrom(res, isChild, isAnnotation);
    }
}

