/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.factory;

import org.ow2.weblab.core.extended.exception.WebLabRISyntaxException;
import org.ow2.weblab.core.extended.exception.WebLabResourceCreationException;
import org.ow2.weblab.core.extended.uri.WebLabRI;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.ResultSet;

public class PoKFactory {
    private static final char POK_CHAR = 'p';

    private PoKFactory() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static PieceOfKnowledge createAndLinkPoK(ResultSet resultSet) {
        PieceOfKnowledge pok = new PieceOfKnowledge();
        try {
            pok.setUri(PoKFactory.getUniqueWelLabRIFrom(resultSet));
            resultSet.setPok(pok);
        }
        catch (WebLabRISyntaxException wlrise) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: PieceOfKnowledge", wlrise);
        }
        return pok;
    }

    private static final String getUniqueWelLabRIFrom(ResultSet resultSet) {
        WebLabRI uri = new WebLabRI(resultSet.getUri());
        uri.addFragment("p");
        return uri.toString();
    }
}

