/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.factory;

import org.ow2.weblab.core.extended.exception.WebLabRISyntaxException;
import org.ow2.weblab.core.extended.exception.WebLabResourceCreationException;
import org.ow2.weblab.core.extended.factory.AbstractFactory;
import org.ow2.weblab.core.extended.uri.WebLabRI;
import org.ow2.weblab.core.model.Resource;

public class ResourceFactory
extends AbstractFactory {
    protected static final char SEPARATOR = '-';

    private ResourceFactory() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static <T extends Resource> T createResource(String idRef, String idRes, Class<T> resClass) {
        Resource resource;
        try {
            resource = (Resource)resClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + resClass.getSimpleName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + resClass.getSimpleName(), iae);
        }
        try {
            WebLabRI wri = new WebLabRI("weblab://" + idRef + "/" + idRes);
            if (wri.getFragment() != null) {
                throw new WebLabRISyntaxException(wri.toString());
            }
            resource.setUri(wri.toString());
            AbstractFactory.cleanMapping(wri.toString());
        }
        catch (WebLabRISyntaxException wlrise) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + resClass.getSimpleName(), wlrise);
        }
        return (T)resource;
    }
}

