/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.factory;

import java.util.LinkedList;
import java.util.List;
import org.ow2.weblab.core.extended.exception.WebLabResourceCreationException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.AbstractFactory;
import org.ow2.weblab.core.model.Coordinate;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.SpatialSegment;
import org.ow2.weblab.core.model.SpatioTemporalSegment;
import org.ow2.weblab.core.model.TemporalSegment;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.model.TrackSegment;

public class SegmentFactory
extends AbstractFactory {
    private SegmentFactory() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static final LinearSegment createAndLinkLinearSegment(Text text, int start, int end) {
        return SegmentFactory.createAndLinkLinearSegment(text, start, end, false);
    }

    public static final LinearSegment createAndLinkLinearSegment(Text text, int start, int end, boolean enableCollocatedSegment) {
        SegmentFactory.checkArgsForLinearAndTemporal(text, start, end);
        LinearSegment theSeg = null;
        if (!enableCollocatedSegment) {
            theSeg = SegmentFactory.getExistingSegment(text.getSegment(), start, end, LinearSegment.class);
        }
        if (theSeg == null) {
            theSeg = SegmentFactory.createAndLinkSegment((MediaUnit)text, LinearSegment.class);
            theSeg.setStart(start);
            theSeg.setEnd(end);
        }
        return theSeg;
    }

    public static final LinearSegment createAndLinkLinearSegment(TrackSegment track, int start, int end) {
        SegmentFactory.checkArgsForLinearAndTemporal(track, start, end);
        LinearSegment lSeg = SegmentFactory.createAndLinkSegment(track, LinearSegment.class);
        lSeg.setStart(start);
        lSeg.setEnd(end);
        return lSeg;
    }

    public static final TemporalSegment createAndLinkTemporalSegment(MediaUnit mu, int start, int end) {
        return SegmentFactory.createAndLinkTemporalSegment(mu, start, end, false);
    }

    public static final TemporalSegment createAndLinkTemporalSegment(MediaUnit mu, int start, int end, boolean enableCollocatedSegment) {
        SegmentFactory.checkArgsForLinearAndTemporal(mu, start, end);
        TemporalSegment theSeg = null;
        if (!enableCollocatedSegment) {
            theSeg = SegmentFactory.getExistingSegment(mu.getSegment(), start, end, TemporalSegment.class);
        }
        if (theSeg == null) {
            theSeg = SegmentFactory.createAndLinkSegment(mu, TemporalSegment.class);
            theSeg.setStart(start);
            theSeg.setEnd(end);
        }
        return theSeg;
    }

    public static final TemporalSegment createAndLinkTemporalSegment(TrackSegment track, int start, int end) {
        SegmentFactory.checkArgsForLinearAndTemporal(track, start, end);
        TemporalSegment tSeg = SegmentFactory.createAndLinkSegment(track, TemporalSegment.class);
        tSeg.setStart(start);
        tSeg.setEnd(end);
        return tSeg;
    }

    public static final SpatioTemporalSegment createAndLinkSpatioTemporalSegment(MediaUnit mu, int timestamp, int ... shape) {
        List<Coordinate> coordinates = SegmentFactory.checkAndcreateCoordinates(mu, shape);
        SpatioTemporalSegment theSeg = SegmentFactory.createAndLinkSegment(mu, SpatioTemporalSegment.class);
        theSeg.setTimestamp(timestamp);
        theSeg.getCoordinate().addAll(coordinates);
        return theSeg;
    }

    public static final SpatioTemporalSegment createAndLinkSpatioTemporalSegment(TrackSegment track, int timestamp, int ... shape) {
        List<Coordinate> coordinates = SegmentFactory.checkAndcreateCoordinates(track, shape);
        SpatioTemporalSegment theSeg = SegmentFactory.createAndLinkSegment(track, SpatioTemporalSegment.class);
        theSeg.setTimestamp(timestamp);
        theSeg.getCoordinate().addAll(coordinates);
        return theSeg;
    }

    public static final SpatialSegment createAndLinkSpatialSegment(MediaUnit mu, int ... shape) {
        List<Coordinate> coordinates = SegmentFactory.checkAndcreateCoordinates(mu, shape);
        SpatialSegment theSeg = SegmentFactory.createAndLinkSegment(mu, SpatialSegment.class);
        theSeg.getCoordinate().addAll(coordinates);
        return theSeg;
    }

    public static final SpatialSegment createAndLinkSpatialSegment(TrackSegment track, int ... shape) {
        List<Coordinate> coordinates = SegmentFactory.checkAndcreateCoordinates(track, shape);
        SpatialSegment theSeg = SegmentFactory.createAndLinkSegment(track, SpatialSegment.class);
        theSeg.getCoordinate().addAll(coordinates);
        return theSeg;
    }

    private static List<Coordinate> checkAndcreateCoordinates(Object container, int ... shape) {
        if (container == null || shape == null) {
            throw new WebLabUncheckedException("Argument was null.");
        }
        if (shape.length % 2 != 0) {
            throw new WebLabUncheckedException("Coordinate array not valid (should be of an even length).");
        }
        if (shape.length < 4) {
            throw new WebLabUncheckedException("Not enought coordinates in the shape array (at least two points should be described, i.e. 4 int).");
        }
        LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
        for (int i = 0; i < shape.length / 2; ++i) {
            Coordinate coordoI = new Coordinate();
            coordoI.setX(shape[2 * i]);
            coordoI.setY(shape[2 * i + 1]);
            coordinates.add(coordoI);
        }
        return coordinates;
    }

    public static final <T extends Segment> T createAndLinkSegment(MediaUnit mediaUnit, Class<T> segClass) {
        Segment segment;
        try {
            segment = (Segment)segClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + segClass.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + segClass.getName(), iae);
        }
        segment.setUri(AbstractFactory.createUniqueURIFrom((Resource)mediaUnit, true, false));
        AbstractFactory.addSegment(segment, mediaUnit, (Resource)mediaUnit);
        return (T)segment;
    }

    public static final <T extends Segment> T createAndLinkSegment(TrackSegment track, Class<T> segClass) {
        Segment segment;
        try {
            segment = (Segment)segClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + segClass.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + segClass.getName(), iae);
        }
        segment.setUri(AbstractFactory.createSegmentURIFor(track));
        track.getSegment().add(segment);
        return (T)segment;
    }

    private static <T extends Segment> T getExistingSegment(List<Segment> segments, int start, int end, Class<T> linearOrTemporalSegment) {
        boolean isLinear = linearOrTemporalSegment.equals(LinearSegment.class);
        Segment theSeg = null;
        for (Segment seg : segments) {
            TemporalSegment tempSeg;
            if (seg instanceof LinearSegment && isLinear) {
                LinearSegment linSeg = (LinearSegment)seg;
                if (linSeg.getStart() != start || linSeg.getEnd() != end) continue;
                theSeg = (Segment)linearOrTemporalSegment.cast(linSeg);
                break;
            }
            if (!(seg instanceof TemporalSegment) || isLinear || (tempSeg = (TemporalSegment)seg).getStart() != start || tempSeg.getEnd() != end) continue;
            theSeg = (Segment)linearOrTemporalSegment.cast(tempSeg);
            break;
        }
        return (T)theSeg;
    }

    private static void checkArgsForLinearAndTemporal(Object container, int start, int end) {
        if (container == null) {
            throw new WebLabUncheckedException("Argument was null.");
        }
        if (start > end) {
            throw new WebLabUncheckedException("Starting index was bigger than ending one.");
        }
    }
}

