/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.ontologies;

import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Segment;

public class WebLabModel {
    public static final String NAMESPACE = "http://weblab.ow2.org/core/1.2/ontology/model#";
    public static final String PREFIX = "model";
    public static final String ANNOTATION = "http://weblab.ow2.org/core/1.2/ontology/model#Annotation";
    public static final String AUDIO = "http://weblab.ow2.org/core/1.2/ontology/model#Audio";
    public static final String COMPOSED_QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#ComposedQuery";
    public static final String COMPOSED_RESOURCE = "http://weblab.ow2.org/core/1.2/ontology/model#ComposedResource";
    public static final String COORDINATE = "http://weblab.ow2.org/core/1.2/ontology/model#Coordinate";
    public static final String DOCUMENT = "http://weblab.ow2.org/core/1.2/ontology/model#Document";
    public static final String ELEMENTARY_QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#ElementaryQuery";
    public static final String IMAGE = "http://weblab.ow2.org/core/1.2/ontology/model#Image";
    public static final String LINEAR_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#LinearSegment";
    public static final String LOW_LEVEL_DESCRIPTOR = "http://weblab.ow2.org/core/1.2/ontology/model#LowLevelDescriptor";
    public static final String MEDIA_UNIT = "http://weblab.ow2.org/core/1.2/ontology/model#MediaUnit";
    public static final String PIECE_OF_KNOWLEDGE = "http://weblab.ow2.org/core/1.2/ontology/model#PieceOfKnowledge";
    public static final String QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#Query";
    public static final String RESOURCE = "http://weblab.ow2.org/core/1.2/ontology/model#Resource";
    public static final String RESULT_SET = "http://weblab.ow2.org/core/1.2/ontology/model#ResultSet";
    public static final String SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#Segment";
    public static final String SIMILARITY_QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#SimilarityQuery";
    public static final String SPATIAL_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#SpatialSegment";
    public static final String SPATIO_TEMPORAL_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#SpatioTemporalSegment";
    public static final String STRING_QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#StringQuery";
    public static final String TEMPORAL_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#TemporalSegment";
    public static final String TEXT = "http://weblab.ow2.org/core/1.2/ontology/model#Text";
    public static final String TRACK_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#TrackSegment";
    public static final String VIDEO = "http://weblab.ow2.org/core/1.2/ontology/model#Video";
    public static final String HAS_ANNOTATION = "http://weblab.ow2.org/core/1.2/ontology/model#hasAnnotation";
    public static final String HAS_COORDINATE = "http://weblab.ow2.org/core/1.2/ontology/model#hasCoordinate";
    public static final String HAS_LOW_LEVEL_DESCRIPTOR = "http://weblab.ow2.org/core/1.2/ontology/model#hasLowLevelDescriptor";
    public static final String HAS_POK = "http://weblab.ow2.org/core/1.2/ontology/model#hasPok";
    public static final String HAS_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#hasSegment";
    public static final String IS_COMPOSED_BY_SEGMENT = "http://weblab.ow2.org/core/1.2/ontology/model#isComposedBySegment";
    public static final String IN_COMPOSED_QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#inComposedQuery";
    public static final String IS_COMPOSED_BY_QUERY = "http://weblab.ow2.org/core/1.2/ontology/model#isComposedByQuery";
    public static final String IN_COMPOSED_RESOURCE = "http://weblab.ow2.org/core/1.2/ontology/model#inComposedResource";
    public static final String IS_COMPOSED_BY_RESOURCE = "http://weblab.ow2.org/core/1.2/ontology/model#isComposedByResource";
    public static final String IN_DOCUMENT = "http://weblab.ow2.org/core/1.2/ontology/model#inDocument";
    public static final String IS_COMPOSED_BY_MEDIA_UNIT = "http://weblab.ow2.org/core/1.2/ontology/model#isComposedByMediaUnit";
    public static final String IN_RESULT_SET = "http://weblab.ow2.org/core/1.2/ontology/model#inResultSet";
    public static final String IS_COMPOSED_BY_RESOURCE_RESULT_SET = "http://weblab.ow2.org/core/1.2/ontology/model#isComposedByResourceResultSet";
    public static final String END_AT = "http://weblab.ow2.org/core/1.2/ontology/model#endAt";
    public static final String START_AT = "http://weblab.ow2.org/core/1.2/ontology/model#startAt";
    public static final String HAS_TIMESTAMP = "http://weblab.ow2.org/core/1.2/ontology/model#hasTimeStamp";
    public static final String HAS_WEIGHT = "http://weblab.ow2.org/core/1.2/ontology/model#hasWeight";
    public static final String HAS_DATA = "http://weblab.ow2.org/core/1.2/ontology/model#hasData";
    public static final String HAS_URI = "http://weblab.ow2.org/core/1.2/ontology/model#hasUri";
    public static final String HAS_REQUEST = "http://weblab.ow2.org/core/1.2/ontology/model#hasRequest";
    public static final String HAS_CONTENT = "http://weblab.ow2.org/core/1.2/ontology/model#hasContent";
    public static final String HAS_TEXT_CONTENT = "http://weblab.ow2.org/core/1.2/ontology/model#hasTextContent";
    public static final String HAS_OPERATOR = "http://weblab.ow2.org/core/1.2/ontology/model#hasOperator";
    public static final String HAS_ABSCISSA = "http://weblab.ow2.org/core/1.2/ontology/model#hasAbscissa";
    public static final String HAS_ORDINATE = "http://weblab.ow2.org/core/1.2/ontology/model#hasOrdinate";

    private WebLabModel() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static String getUriFromResource(Class<? extends Resource> resourceClass) {
        return NAMESPACE + resourceClass.getSimpleName();
    }

    public static String getUriFromSegment(Class<? extends Segment> segmentClass) {
        return NAMESPACE + segmentClass.getSimpleName();
    }

    public static Class<?> getClassFromUri(String uri) throws ClassNotFoundException {
        if (uri == null || uri.length() <= NAMESPACE.length() || !uri.startsWith(NAMESPACE)) {
            throw new WebLabUncheckedException("Uri: " + uri + " was not a WebLab class. ");
        }
        String className = '.' + uri.substring(NAMESPACE.length());
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(Resource.class.getPackage().getName() + className);
        if (Resource.class.isAssignableFrom(clazz)) {
            return clazz.asSubclass(Resource.class);
        }
        if (Segment.class.isAssignableFrom(clazz)) {
            return clazz.asSubclass(Segment.class);
        }
        throw new ClassCastException("The URI '" + uri + "' denotes the class " + clazz.getCanonicalName() + " which is neither a resource nor a segment.");
    }
}

