/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public final class PropertiesLoader {
    private PropertiesLoader() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadProperties(String filename, Class<?> clazz) {
        Enumeration<URL> urls;
        Properties properties = new Properties();
        try {
            urls = clazz.getClassLoader().getResources(filename);
        }
        catch (IOException ioe) {
            throw new WebLabUncheckedException("Unable to load properties file: '" + filename + "'.", ioe);
        }
        if (!urls.hasMoreElements()) {
            throw new WebLabUncheckedException("Properties file '" + filename + "' not found.");
        }
        URL file = urls.nextElement();
        if (urls.hasMoreElements()) {
            StringBuilder warn = new StringBuilder();
            warn.append("-" + file.toString());
            while (urls.hasMoreElements()) {
                warn.append(System.getProperty("line.separator"));
                warn.append("-");
                warn.append(urls.nextElement().toString());
            }
            LogFactory.getLog(PropertiesLoader.class).warn((Object)("Too many properties files founded:" + System.getProperty("line.separator") + warn.toString()));
            LogFactory.getLog(PropertiesLoader.class).warn((Object)("Selected: " + file));
        }
        try {
            InputStream stream = file.openStream();
            try {
                properties.load(stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(PropertiesLoader.class).warn((Object)"Unable to close stream when loading properties.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabUncheckedException("Unable to load " + filename + " file.", ioe);
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return propertiesMap;
    }

    public static Map<String, String> loadProperties(String filename) {
        return PropertiesLoader.loadProperties(filename, PropertiesLoader.class);
    }
}

