/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.uri;

import java.net.URI;
import java.net.URISyntaxException;
import org.ow2.weblab.core.extended.exception.WebLabRISyntaxException;

public class WebLabRI {
    private URI uri;

    public WebLabRI(String uriStr) {
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException urise) {
            throw new WebLabRISyntaxException(urise);
        }
    }

    public void addFragment(String fragment) {
        if (this.uri.getFragment() == null) {
            try {
                this.uri = new URI(this.uri.toString() + "#" + fragment);
            }
            catch (URISyntaxException urise) {
                throw new WebLabRISyntaxException(urise);
            }
        }
        try {
            this.uri = new URI(this.uri.toString() + "-" + fragment);
        }
        catch (URISyntaxException urise) {
            throw new WebLabRISyntaxException(urise);
        }
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String toString() {
        return this.uri.toString();
    }
}

