/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.util;

import java.util.List;
import org.ow2.weblab.core.extended.exception.WebLabNotYetImplementedException;
import org.ow2.weblab.core.model.Coordinate;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.SpatialSegment;
import org.ow2.weblab.core.model.SpatioTemporalSegment;
import org.ow2.weblab.core.model.TemporalSegment;
import org.ow2.weblab.core.model.TrackSegment;

public class SegmentUtil {
    private SegmentUtil() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static boolean isIncluded(Segment theSegment, Segment inThisSegment) {
        if (theSegment == inThisSegment) {
            return true;
        }
        if (theSegment == null || inThisSegment == null) {
            return false;
        }
        if (!theSegment.getClass().equals(inThisSegment.getClass())) {
            return false;
        }
        if (theSegment instanceof LinearSegment) {
            return SegmentUtil.isIncludedLinear((LinearSegment)theSegment, (LinearSegment)inThisSegment);
        }
        if (theSegment instanceof TemporalSegment) {
            return SegmentUtil.isIncludedTemporal((TemporalSegment)theSegment, (TemporalSegment)inThisSegment);
        }
        if (theSegment instanceof SpatioTemporalSegment) {
            return SegmentUtil.isIncludedSpatioTemporalSegment((SpatioTemporalSegment)theSegment, (SpatioTemporalSegment)inThisSegment);
        }
        if (theSegment instanceof SpatialSegment) {
            return SegmentUtil.isIncludedSpatial((SpatialSegment)theSegment, (SpatialSegment)inThisSegment);
        }
        if (theSegment instanceof TrackSegment) {
            return false;
        }
        throw new WebLabNotYetImplementedException("Inclusion test for type " + theSegment.getClass().getName() + " not yet implemented !!!");
    }

    private static boolean isIncludedSpatioTemporalSegment(SpatioTemporalSegment theSegment, SpatioTemporalSegment inThisSegment) {
        if (theSegment.getTimestamp() == inThisSegment.getTimestamp()) {
            return SegmentUtil.isIncludedCoordinate(theSegment.getCoordinate(), inThisSegment.getCoordinate());
        }
        return false;
    }

    private static boolean isIncludedLinear(LinearSegment theSegment, LinearSegment inThisSegment) {
        return theSegment.getStart() >= inThisSegment.getStart() && theSegment.getEnd() <= inThisSegment.getEnd();
    }

    private static boolean isIncludedTemporal(TemporalSegment theSegment, TemporalSegment inThisSegment) {
        return theSegment.getStart() >= inThisSegment.getStart() && theSegment.getEnd() <= inThisSegment.getEnd();
    }

    private static boolean isIncludedSpatial(SpatialSegment theSegment, SpatialSegment inThisSegment) {
        return SegmentUtil.isIncludedCoordinate(theSegment.getCoordinate(), inThisSegment.getCoordinate());
    }

    private static boolean isIncludedCoordinate(List<Coordinate> coordinate, List<Coordinate> inCoordinates) {
        throw new WebLabNotYetImplementedException("Inclusion test using coordinates is not yet implemented!");
    }
}

