/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.util;

import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.Analyser_Service;
import org.ow2.weblab.core.services.Indexer;
import org.ow2.weblab.core.services.Indexer_Service;
import org.ow2.weblab.core.services.QueueManager;
import org.ow2.weblab.core.services.QueueManager_Service;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.Searcher_Service;
import org.ow2.weblab.core.services.SourceReader;
import org.ow2.weblab.core.services.SourceReader_Service;

public class ServiceUtil {
    private static final String SERVICES_NAMESPACE = "http://weblab.ow2.org/core/1.2/services";

    private ServiceUtil() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static void setEndpointAddress(Object port, String newAddress, String SOAPAction) {
        if (!(port instanceof BindingProvider)) {
            throw new WebLabUncheckedException("Object: " + port + " doesn't appear to be a valid port.");
        }
        Map context = ((BindingProvider)port).getRequestContext();
        context.put("javax.xml.ws.service.endpoint.address", newAddress);
        context.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        context.put("javax.xml.ws.soap.http.soapaction.uri", SOAPAction);
    }

    public static Analyser getAnalyserService(URL WSDLLocation, URL analyserEndpointAddress) {
        Analyser analyser = new Analyser_Service(WSDLLocation, new QName(SERVICES_NAMESPACE, "Analyser")).getAnalyserPort();
        ServiceUtil.setEndpointAddress(analyser, analyserEndpointAddress.toString(), "process");
        return analyser;
    }

    public static QueueManager getQueueManagerService(URL WSDLLocation, URL queueManagerEndpointAddress) {
        QueueManager manager = new QueueManager_Service(WSDLLocation, new QName(SERVICES_NAMESPACE, "QueueManager")).getQueueManagerPort();
        ServiceUtil.setEndpointAddress(manager, queueManagerEndpointAddress.toString(), "nextResource");
        return manager;
    }

    public static Indexer getIndexerService(URL WSDLLocation, URL indexerEndpointAddress) {
        Indexer indexer = new Indexer_Service(WSDLLocation, new QName(SERVICES_NAMESPACE, "Indexer")).getIndexerPort();
        ServiceUtil.setEndpointAddress(indexer, indexerEndpointAddress.toString(), "index");
        return indexer;
    }

    public static Searcher getSearcherService(URL WSDLLocation, URL searcherEndpointAddress) {
        Searcher searcher = new Searcher_Service(WSDLLocation, new QName(SERVICES_NAMESPACE, "Searcher")).getSearcherPort();
        ServiceUtil.setEndpointAddress(searcher, searcherEndpointAddress.toString(), "search");
        return searcher;
    }

    public static SourceReader getSourceReaderService(URL WSDLLocation, URL searcherEndpointAddress) {
        SourceReader searcher = new SourceReader_Service(WSDLLocation, new QName(SERVICES_NAMESPACE, "SourceReader")).getSourceReaderPort();
        ServiceUtil.setEndpointAddress(searcher, searcherEndpointAddress.toString(), "search");
        return searcher;
    }
}

