/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.extended.factory;

import org.ow2.weblab.core.model.LowLevelDescriptor;
import org.ow2.weblab.core.model.Resource;


/**
 * This class will provide an easy and strongly recommended way to create <code>LowLevelDescriptor</code>s.it will
 * enable the creation of a <code>LowLevelDescriptor</code> having an <code>URI</code> compliant with
 * the <code>WebLabRI</code> recommendations. <br />
 * Since an <code>LowLevelDescriptor</code> hasn't any sense without being
 * attached to a <code>Resource</code>, we only provide a method for creating <code>LowLevelDescriptor</code>s that
 * takes a <code>Resource</code> in
 * parameter. As a result, the created <code>LowLevelDescriptor</code> is
 * added to the <code>LowLevelDescriptor</code> <code>List</code> of the <code>Resource</code>.
 * 
 * @author Cassidian WebLab Team
 * @date 2008-04-11
 */
public class LowLevelDescriptorFactory extends AbstractFactory {

	/**
	 * Constructors
	 * Do not use it.
	 */
	private LowLevelDescriptorFactory() {
		throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
	}

	/**
	 * Method that should create and link a <code>LowLevelDescriptor</code> from/to a <code>Resource</code>.
	 * Automatically set a valid <code>WebLabRI</code> to the created <code>LowLevelDescriptor</code> using the
	 * <code>Resource</code> in parameter to generate an unique id.
	 * Created <code>LowLevelDescriptor</code> will be added to <code>resource</code>.
	 * 
	 * @param res
	 *            The <code>Resource</code> to be described by the <code>LowLevelDescriptor</code>.
	 * @return The <code>LowLevelDescriptor</code> describing <code>res</code>.
	 */
	public static final LowLevelDescriptor createAndLinkLowLevelDescriptor(Resource res) {
		final LowLevelDescriptor desc = new LowLevelDescriptor();
		desc.setUri(AbstractFactory.createUniqueURIFrom(res, true, false));
		AbstractFactory.addDescriptor(desc, res, res);
		return desc;
	}


}
