/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.factory;

import org.ow2.weblab.core.extended.exception.WebLabResourceCreationException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.AbstractFactory;
import org.ow2.weblab.core.model.LinearSegment;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Segment;
import org.ow2.weblab.core.model.Text;

public class SegmentFactory
extends AbstractFactory {
    private SegmentFactory() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static final LinearSegment createAndLinkLinearSegment(Text text, int start, int end) {
        if (text == null) {
            throw new WebLabUncheckedException("Argument was null");
        }
        if (start >= end) {
            throw new WebLabUncheckedException("Starting index was bigger than ending one");
        }
        LinearSegment theSeg = null;
        for (Segment seg : text.getSegment()) {
            LinearSegment linSeg;
            if (!(seg instanceof LinearSegment) || (linSeg = (LinearSegment)seg).getStart() != start || linSeg.getEnd() != end) continue;
            theSeg = linSeg;
            break;
        }
        if (theSeg == null) {
            theSeg = SegmentFactory.createAndLinkSegment((MediaUnit)text, LinearSegment.class);
            theSeg.setStart(start);
            theSeg.setEnd(end);
        }
        return theSeg;
    }

    public static final <T extends Segment> T createAndLinkSegment(MediaUnit mediaUnit, Class<T> segClass) {
        Segment segment;
        try {
            segment = (Segment)segClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + segClass.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabResourceCreationException("Error when trying to instanciate: " + segClass.getName(), iae);
        }
        segment.setUri(AbstractFactory.createUniqueURIFrom((Resource)mediaUnit, true, false));
        AbstractFactory.addSegment(segment, mediaUnit, (Resource)mediaUnit);
        return (T)segment;
    }
}

