/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.jaxb;

public class XMLStringCleaner {
    private XMLStringCleaner() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static String getXMLRecommendedString(String input) {
        return XMLStringCleaner.getXMLRecommendedString(input, false, ' ');
    }

    private static String getXMLRecommendedString(String input, boolean replace, char replacement) {
        if (input == null) {
            return null;
        }
        if ("".equals(input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (XMLStringCleaner.isXMLRecommended(c)) {
                sb.append(c);
                continue;
            }
            if (!replace) continue;
            sb.append(replacement);
        }
        return sb.toString();
    }

    public static String getXMLRecommendedString(String input, char replacement) {
        return XMLStringCleaner.getXMLRecommendedString(input, true, replacement);
    }

    public static String getXMLValidString(String input) {
        return XMLStringCleaner.getXMLValidString(input, false, ' ');
    }

    public static String getXMLValidString(String input, char replacement) {
        return XMLStringCleaner.getXMLValidString(input, true, replacement);
    }

    private static String getXMLValidString(String input, boolean replace, char replacement) {
        if (input == null) {
            return null;
        }
        if ("".equals(input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (XMLStringCleaner.isXMLValid(c)) {
                sb.append(c);
                continue;
            }
            if (!replace) continue;
            sb.append(replacement);
        }
        return sb.toString();
    }

    public static boolean isXMLRecommended(char c) {
        return !(!XMLStringCleaner.isXMLValid(c) || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufddf');
    }

    public static boolean isXMLValid(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }
}

