/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.extended.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.SimilarityQuery;

public class ResourceUtil {
    private ResourceUtil() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    public static void printTree(Resource res, OutputStream stream) {
        PrintWriter printWriter = new PrintWriter(stream, true);
        ResourceUtil.printTree(res, printWriter, "");
    }

    public static String saveToXMLString(Resource resource) throws WebLabCheckedException {
        StringWriter sw = new StringWriter();
        new WebLabMarshaller().marshalResource(resource, sw);
        return sw.toString();
    }

    public static Resource loadFromXMLString(String xml) throws WebLabCheckedException {
        return new WebLabMarshaller().unmarshal(new StringReader(xml), Resource.class);
    }

    private static void printTree(Resource res, PrintWriter writer, String gap) {
        writer.println(gap + res.getUri() + "  " + res.getClass().getSimpleName());
        for (Resource subResource : ResourceUtil.getDirectSubResources(res)) {
            ResourceUtil.printTree(subResource, writer, gap + "  ");
        }
    }

    private static List<Resource> getDirectSubResources(Resource res) {
        Document doc;
        ArrayList<Resource> subResources = new ArrayList<Resource>();
        if (res.isSetAnnotation()) {
            subResources.addAll(res.getAnnotation());
        }
        if (res.isSetDescriptor()) {
            subResources.addAll(res.getDescriptor());
        }
        if (res instanceof ResultSet) {
            ResultSet rs = (ResultSet)res;
            if (rs.isSetPok()) {
                subResources.add((Resource)rs.getPok());
            }
            if (rs.isSetResource()) {
                subResources.addAll(rs.getResource());
            }
        } else if (res instanceof ComposedResource) {
            subResources.addAll(((ComposedResource)res).getResource());
        } else if (res instanceof ComposedQuery) {
            subResources.addAll(((ComposedQuery)res).getQuery());
        } else if (res instanceof SimilarityQuery) {
            subResources.addAll(((SimilarityQuery)res).getResource());
        } else if (res instanceof Document && (doc = (Document)res).isSetMediaUnit()) {
            subResources.addAll(doc.getMediaUnit());
        }
        return subResources;
    }

    public static List<Resource> getSubResources(Resource res) {
        return new ArrayList<Resource>(ResourceUtil.getSubResources1(res).keySet());
    }

    private static Map<Resource, Resource> getSubResources1(Resource res) {
        LinkedHashMap<Resource, Resource> resources = new LinkedHashMap<Resource, Resource>();
        List<Resource> subs = ResourceUtil.getDirectSubResources(res);
        for (Resource sub : subs) {
            resources.put(sub, res);
            resources.putAll(ResourceUtil.getSubResources1(sub));
        }
        return resources;
    }

    public static <T extends Resource> List<T> getSelectedSubResources(Resource res, Class<T> resClass) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : ResourceUtil.getSubResources1(res).keySet()) {
            if (!resClass.isInstance(r)) continue;
            Resource muAsT = (Resource)resClass.cast(r);
            result.add(muAsT);
        }
        return result;
    }

    public static <T extends Resource> Map<T, Resource> getSelectedSubResourcesMap(Resource res, Class<T> resClass) {
        LinkedHashMap<Resource, Resource> result = new LinkedHashMap<Resource, Resource>();
        for (Map.Entry<Resource, Resource> entry : ResourceUtil.getSubResources1(res).entrySet()) {
            if (!resClass.isInstance(entry.getKey())) continue;
            Resource muAsT = (Resource)resClass.cast(entry.getKey());
            result.put(muAsT, entry.getValue());
        }
        return result;
    }
}

