
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * This kind of Query is only an aggregation of Queries using a n-ary boolean operator to combine them. Composing Queries using various 
 *             ComposedQueries will enable to deal with brackets. Please note that when dealing with the operators AND and OR, the number of used 
 *             Queries should be at least two; used with a simple Query it will have no effects. NOT is an unary operator, so the list 
 *             of Queries should be reduced to one, but when using it in a more-that-one-query list, a AND NOT operator will be used.
 * 
 * 				Data Exchange Model for WebLab platform provided by CASSIDIAN Version 1.2.1 - 2011/05
 * 
 * <p>Java class for ComposedQuery complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ComposedQuery">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Query">
 *       &lt;sequence>
 *         &lt;element name="query" type="{http://weblab.ow2.org/core/1.2/model#}Query" maxOccurs="unbounded"/>
 *         &lt;element name="operator" type="{http://weblab.ow2.org/core/1.2/model#}operator"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ComposedQuery", propOrder = {
    "query",
    "operator"
})
public class ComposedQuery
    extends Query
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    @XmlElement(required = true)
    protected List<Query> query;
    @XmlElement(required = true)
    protected Operator operator;

    /**
     * Gets the value of the query property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the query property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Query }
     * 
     * 
     */
    public List<Query> getQuery() {
        if (query == null) {
            query = new ArrayList<Query>();
        }
        return this.query;
    }

    /**
     * Gets the value of the operator property.
     * 
     * @return
     *     possible object is
     *     {@link Operator }
     *     
     */
    public Operator getOperator() {
        return operator;
    }

    /**
     * Sets the value of the operator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Operator }
     *     
     */
    public void setOperator(Operator value) {
        this.operator = value;
    }

}
