
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * A ComposedResource defines a simple aggregate of resources and allows to regroup them within the same unit. Since a multimedia 
 *             document is a resource, the simplest ComposedResource will be a corpus of documents such as videos about the same program during 
 *             one year. It could also be a set of useful resources needed by a service such as a set of annotations or a document with an attached 
 *             PoK that allows to analyse it. As a resource, a ComposedResource could be annotated to provide, for example, meta-information on its
 *              content or the reasons of the aggregate.
 * 
 * 				Data Exchange Model for WebLab platform provided by CASSIDIAN Version 1.2.1 - 2011/05
 * 
 * <p>Java class for ComposedResource complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ComposedResource">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *       &lt;sequence>
 *         &lt;element name="resource" type="{http://weblab.ow2.org/core/1.2/model#}Resource" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ComposedResource", propOrder = {
    "resource"
})
public class ComposedResource
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    @XmlElement(required = true)
    protected List<Resource> resource;

    /**
     * Gets the value of the resource property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the resource property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResource().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Resource }
     * 
     * 
     */
    public List<Resource> getResource() {
        if (resource == null) {
            resource = new ArrayList<Resource>();
        }
        return this.resource;
    }

}
