
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * A Query is a resource which contains request data. This data describes each specific specialisation of query, in a specific format. 
 *             The Query object is then abstract and several specialisations will be used to describe any types of queries. A proposal is to adopt 
 *             common standards in order to provide consistent definitions over all the WebLab platform. XQuery and SPARQL	formats have been 
 *             identified as promising candidates respectively for structured and semantic search. As a resource, a Query could be annotated to 
 *             provide, for example, meta-informations such as its syntax or its creation date.
 * 
 * 
 * 				Data Exchange Model for WebLab platform provided by CASSIDIAN Version 1.2.1 - 2011/05
 * 
 * <p>Java class for Query complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Query">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Query")
@XmlSeeAlso({
    ComposedQuery.class,
    ElementaryQuery.class
})
public abstract class Query
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 121L;

}
