
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;


/**
 * A ResultSet is a specific resource used to describe results of a Query. The results should be described semantically in the PoK 
 *             linked to the ResultSet. See the WebLab ontology for the properties on ResultSet. Additional and specific information could be added 
 *             for results presentation in the Resources list. As a Resource, a ResultSet could be annotated to provide more information. But any 
 *             information about the results and the query  by themselves shall be in PoK field.
 * 
 * 
 * 				Data Exchange Model for WebLab platform provided by CASSIDIAN Version 1.2.1 - 2011/05
 * 			
 * 
 * <p>Java class for ResultSet complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ResultSet">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *       &lt;sequence>
 *         &lt;element name="resource" type="{http://weblab.ow2.org/core/1.2/model#}Resource" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="pok" type="{http://weblab.ow2.org/core/1.2/model#}PieceOfKnowledge" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ResultSet", propOrder = {
    "resource",
    "pok"
})
public class ResultSet
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    protected List<Resource> resource;
    protected PieceOfKnowledge pok;

    /**
     * Gets the value of the resource property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the resource property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResource().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Resource }
     * 
     * 
     */
    public List<Resource> getResource() {
        if (resource == null) {
            resource = new ArrayList<Resource>();
        }
        return this.resource;
    }

    public boolean isSetResource() {
        return ((this.resource!= null)&&(!this.resource.isEmpty()));
    }

    public void unsetResource() {
        this.resource = null;
    }

    /**
     * Gets the value of the pok property.
     * 
     * @return
     *     possible object is
     *     {@link PieceOfKnowledge }
     *     
     */
    public PieceOfKnowledge getPok() {
        return pok;
    }

    /**
     * Sets the value of the pok property.
     * 
     * @param value
     *     allowed object is
     *     {@link PieceOfKnowledge }
     *     
     */
    public void setPok(PieceOfKnowledge value) {
        this.pok = value;
    }

    public boolean isSetPok() {
        return (this.pok!= null);
    }

}
