
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * A Segment is an object that do not have any content and which is linked to a media unit. It allows pointing the content of a unit at 
 *             much finer level. Information and annotation about this Segment should be part of the media that handles this Segment. It 
 *             provides a way to assign annotation on a very high level of structure description. The object will contain positioning information 
 *             which allows localising itself in its parent unit. As media type are very different, the position itself will be specialised to them 
 *             and thus, provide localisation adapted to the media. This object cannot be used itself (this is an abstract object). However, some 
 *             implementations with real capabilities are developed in order to match every media class.
 * 
 * 
 * 				Data Exchange Model for WebLab platform provided by CASSIDIAN Version 1.2.1 - 2011/05
 * 
 * <p>Java class for Segment complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Segment">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="uri" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Segment")
@XmlSeeAlso({
    SpatialSegment.class,
    LinearSegment.class,
    TemporalSegment.class,
    TrackSegment.class
})
public abstract class Segment
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    @XmlAttribute(name = "uri", required = true)
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUri(String value) {
        this.uri = value;
    }

}
