
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;


/**
 * A SpatioTemporalSegment aims to give the instant location of an object in a spacial document 
 *         (i.e. Video). For example, one can think of a video showing a moving object. Specific segment can be localised with coordinate 
 *         descriptors defining the border of the object in each of the video images where it appears. Then, specific annotation can be applied to 
 *         each segment. The way to define the location is the same than the SpatialSegment one.
 * 
 * 
 * 				Data Exchange Model for WebLab platform provided by Cassidian, an EADS Company - Version 1.2.1 - 2011/05
 * 			
 * 
 * <p>Java class for SpatioTemporalSegment complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SpatioTemporalSegment">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}SpatialSegment">
 *       &lt;attribute name="timestamp" use="required" type="{http://www.w3.org/2001/XMLSchema}int" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SpatioTemporalSegment")
public class SpatioTemporalSegment
    extends SpatialSegment
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    @XmlAttribute(name = "timestamp", required = true)
    protected int timestamp;

    /**
     * Gets the value of the timestamp property.
     * 
     */
    public int getTimestamp() {
        return timestamp;
    }

    /**
     * Sets the value of the timestamp property.
     * 
     */
    public void setTimestamp(int value) {
        this.timestamp = value;
    }

}
