
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;


/**
 * A Text unit is the simplest specification of the media unit dedicated to full text data. Its unique attribute is a string which is 
 *             in most cases the text extracted from the original document content. This content is optional, since sometimes it might be too 
 *             large to be handled in this field. In that case, we encourage to link it through the same mecanism as Audio/Video/Image content. 
 *             A simple text document such as HTML page could be described by a document which contains a unique Text unit. As a resource, a Text 
 *             unit could be annotated and could also be described with low level descriptors.
 * 
 * 
 * 				Data Exchange Model for WebLab platform provided by CASSIDIAN Version 1.2.1 - 2011/05
 * 
 * <p>Java class for Text complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Text">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}MediaUnit">
 *       &lt;sequence>
 *         &lt;element name="content" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Text", propOrder = {
    "content"
})
public class Text
    extends MediaUnit
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    protected String content;

    /**
     * Gets the value of the content property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContent() {
        return content;
    }

    /**
     * Sets the value of the content property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setContent(String value) {
        this.content = value;
    }

    public boolean isSetContent() {
        return (this.content!= null);
    }

}
