
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * A TrackSegment provides a way to assign a single annotation on a set of linked segments. A TrackSegment is a 
 *         kind of segment and pool several other segments in order to allow the desciption of an entity that appears several times in the annotated 
 *         content.
 * 
 * 				Data Exchange Model for WebLab platform provided by Cassidian, an EADS Company - Version 1.2.1 - 2011/05
 * 
 * <p>Java class for TrackSegment complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="TrackSegment">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Segment">
 *       &lt;sequence>
 *         &lt;element name="segment" type="{http://weblab.ow2.org/core/1.2/model#}Segment" maxOccurs="unbounded" minOccurs="2"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TrackSegment", propOrder = {
    "segment"
})
public class TrackSegment
    extends Segment
    implements Serializable
{

    private final static long serialVersionUID = 121L;
    @XmlElement(required = true)
    protected List<Segment> segment;

    /**
     * Gets the value of the segment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the segment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSegment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Segment }
     * 
     * 
     */
    public List<Segment> getSegment() {
        if (segment == null) {
            segment = new ArrayList<Segment>();
        }
        return this.segment;
    }

    public boolean isSetSegment() {
        return ((this.segment!= null)&&(!this.segment.isEmpty()));
    }

    public void unsetSegment() {
        this.segment = null;
    }

}
