
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;


/**
 * An Annotation will contain a set of RDF
 * 				statements which refer to a specific resource or part of resource
 * 				(segment) known as the subject of the annotations. Thus an
 * 				annotation object is fully dependent on the resource it describes.
 * 				So an Annotation is a PieceOfKnowledge but where each statement in
 * 				its data refers to the resource it depends on. Annotation is one of
 * 				the major objects manipulated through the WebLab platform since it
 * 				will allow adding any particular information on any type of WebLab
 * 				resource. For example, many process services will add annotations in
 * 				order to link the extracted information to the resource processed
 * 				(i.e. a language recognition service will annotate a document in
 * 				order to note the language identified, or perhaps that the language
 * 				could not be recognised).Data Exchange Model for WebLab platform
 * 				provided by CASSIDIAN - Version 1.2 - 2010/08
 * 
 * <p>Java class for Annotation complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Annotation">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}PieceOfKnowledge">
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Annotation")
public class Annotation
    extends PieceOfKnowledge
    implements Serializable
{

    private final static long serialVersionUID = 12L;

}
