
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;


/**
 * A coordinate is a simple container of two
 * 				dimensional coordinate aiming at localising information spatially in
 * 				a mediaUnit; for instance in an image or a video. Those dimensions
 * 				are generally explained in pixel, given the fact that it starts at
 * 				bottom-left with (0;0). Other measure somehow references are
 * 				possible. Data Exchange Model for WebLab platform provided by CASSIDIAN
 * 				Multimedia package - Version 1.2 - 2010/08
 * 
 * <p>Java class for Coordinate complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Coordinate">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="x" use="required" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="y" use="required" type="{http://www.w3.org/2001/XMLSchema}int" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Coordinate")
public class Coordinate
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    @XmlAttribute(required = true)
    protected int x;
    @XmlAttribute(required = true)
    protected int y;

    /**
     * Gets the value of the x property.
     * 
     */
    public int getX() {
        return x;
    }

    /**
     * Sets the value of the x property.
     * 
     */
    public void setX(int value) {
        this.x = value;
    }

    /**
     * Gets the value of the y property.
     * 
     */
    public int getY() {
        return y;
    }

    /**
     * Sets the value of the y property.
     * 
     */
    public void setY(int value) {
        this.y = value;
    }

}
