
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * A low level descriptor is composed of a
 * 				setfeatures that have been extracted from a document or a part of
 * 				document. It aims at representing low level annotation (not at a
 * 				semantic level but at a numerical level) mainly for computing
 * 				similarity between objects For instance, Text could use
 * 				lowLevelDescriuptor to store TFIDF values, Image could use
 * 				lowLevelDescriuptor to handle color histograms.A low level
 * 				descriptor may be composed of a set of features for instance, an
 * 				image may contains edge feature Vector as well as red color
 * 				histogram vector. As a resource, a low level descriptor could be
 * 				annotated to provide, for example, meta information on its creation
 * 				date, its version or its application domain. Data Exchange Model for
 * 				WebLab platform provided by CASSIDIAN - Version 1.2 - 2010/08
 * 			
 * 
 * <p>Java class for LowLevelDescriptor complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="LowLevelDescriptor">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *       &lt;sequence>
 *         &lt;element name="data" type="{http://www.w3.org/2001/XMLSchema}anyType"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LowLevelDescriptor", propOrder = {
    "data"
})
public class LowLevelDescriptor
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    @XmlElement(required = true)
    protected Object data;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setData(Object value) {
        this.data = value;
    }

}
