
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * This is the major object manipulated through
 * 				the WebLab platform. It is mainly assumed that almost all processing
 * 				services should accept the media unit as a common argument and
 * 				provide enhanced media unit as a result. A media unit can be defined
 * 				as the structural annotable representation of any multimedia
 * 				content. It is a resource and thus can be retrieved by an URI and
 * 				annotated by any kind of descriptive annotations or low level
 * 				descriptors. As described in the following sections any particular
 * 				type of media (i.e. picture, text, video segment, audio sample or
 * 				video frame...) will inherit from this object. It could have a
 * 				composed unit as a parent when it is contained in a group of units.
 * 				Finally it could contain annotable segments which will allow
 * 				describing sub-parts of its own content. Data Exchange Model for
 * 				WebLab platform provided by CASSIDIAN - Version 1.2 - 2010/08
 * 			
 * 
 * <p>Java class for MediaUnit complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="MediaUnit">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *       &lt;sequence>
 *         &lt;element name="segment" type="{http://weblab.ow2.org/core/1.2/model#}Segment" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MediaUnit", propOrder = {
    "segment"
})
@XmlSeeAlso({
    Document.class,
    Text.class,
    Image.class,
    Audio.class,
    Video.class
})
public abstract class MediaUnit
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    protected List<Segment> segment;

    /**
     * Gets the value of the segment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the segment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSegment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Segment }
     * 
     * 
     */
    public List<Segment> getSegment() {
        if (segment == null) {
            segment = new ArrayList<Segment>();
        }
        return this.segment;
    }

    public boolean isSetSegment() {
        return ((this.segment!= null)&&(!this.segment.isEmpty()));
    }

    public void unsetSegment() {
        this.segment = null;
    }

}
